/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.AffinityBuildEditor;
import com.ibm.cics.ia.ui.AffinityReportEditor;
import com.ibm.cics.ia.ui.CollectionIdWidget;
import com.ibm.cics.ia.ui.CollectionIdsView;
import com.ibm.cics.ia.ui.CommandFlowDiagram;
import com.ibm.cics.ia.ui.DetailsView;
import com.ibm.cics.ia.ui.IAOperationsView;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.ProgramExplorer;
import com.ibm.cics.ia.ui.QueryResultsView;
import com.ibm.cics.ia.ui.ReportBrowser;
import com.ibm.cics.ia.ui.ResourceConnectionsView;
import com.ibm.cics.ia.ui.ResourceVisualizationView;
import com.ibm.cics.ia.ui.ThreadsafeReportViewImpl;
import com.ibm.cics.ia.ui.TransactionExplorer;
import com.ibm.cics.ia.ui.WebserviceExplorer;
import com.ibm.etools.zusage.core.UsagePlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String WSAA_ACTIVE = "wsaa.active";
    public static final String OFFERING_ID = "5655Y22";
    public static final String ID = "com.ibm.cics.ia.ui";
    public static final String NEW_CICS_QUERY_ID = "com.ibm.cics.ia.action.newcicsquery";
    public static final String NEW_SCANNER_QUERY_ID = "com.ibm.cics.ia.action.newscannerquery";
    public static final String NEW_DB2_QUERY_ID = "com.ibm.cics.ia.action.newdb2query";
    public static final String NEW_AFFINITY_QUERY_ID = "com.ibm.cics.ia.action.newaffinityquery";
    public static final String NEW_MQ_QUERY_ID = "com.ibm.cics.ia.action.newmqquery";
    public static final String NEW_IMS_QUERY_ID = "com.ibm.cics.ia.action.newimsquery";
    public static final String NEW_CMDFLOW_QUERY_ID = "com.ibm.cics.ia.action.newcommandquery";
    public static final String NEW_NATURAL_QUERY_ID = "com.ibm.cics.ia.action.newnaturalquery";
    private static Activator plugin;
    static boolean firstTime;
    private static boolean DEBUG_GENERAL;
    private static final Logger logger;
    private static final String BLANK = "";
    public static final String GENERAL_PREFPAGE_HELP_CTX_ID = "com.ibm.cics.ia.help.general_preference_page";
    public static final String WSAA_PREFPAGE_HELP_CTX_ID = "com.ibm.cics.ia.help.wsaa_preference_page";
    private static String debugPrefix;
    public static final String OPTION_DEBUG_GENERAL;
    private CollectionIdWidget collectionIdWidget = null;
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.ia.connection.atom".equals(event.getConnectionCategoryId())) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    this.collectorConnected(event.getConnectable());
                } else if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                    this.collectorDisconnected(event.getConnectable());
                }
            } else if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    this.db2Disconnected();
                } else if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                    this.closeDetailViews();
                }
            }
        }

        public void closeDetailViews() {
            Debug.enter((Logger)logger, (String)Activator.class.getName(), (String)"closeDetailEditors", (Object)("Thread ID: " + Thread.currentThread().getId()));
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page != null) {
                        IEditorReference[] refs = page.findEditors(null, DetailsView.ID, 2);
                        page.closeEditors(refs, false);
                    }
                }
            });
            Debug.exit((Logger)logger, (String)Activator.class.getName(), (String)"closeDetailEditors");
        }

        public void db2Disconnected() {
            Version.getInstance().reset();
        }

        public void collectorConnected(IConnectable connectable) {
            AtomController controller = AtomController.getInstance();
            controller.connected(connectable);
        }

        public void collectorDisconnected(IConnectable connectable) {
            AtomController controller = AtomController.getInstance();
            controller.disconnected(connectable);
        }
    };

    static {
        firstTime = true;
        logger = Logger.getLogger(Activator.class.getPackage().getName());
        debugPrefix = "com.ibm.cics.ia.ui/";
        OPTION_DEBUG_GENERAL = String.valueOf(debugPrefix) + "general";
        DEBUG_GENERAL = Activator.getBooleanOption(OPTION_DEBUG_GENERAL, true);
    }

    private static boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = Platform.getDebugOption((String)option);
        if (optionValue != null) {
            return optionValue.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        Debug.enter((Logger)logger, (String)Activator.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IAdapterFactory adapterFactory = new IAdapterFactory(){
            private Map commandsToDisplayData = new HashMap();

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                DisplayableData result = (DisplayableData)this.commandsToDisplayData.get(adaptableObject);
                if (result == null) {
                    result = new DisplayableData();
                    this.commandsToDisplayData.put(adaptableObject, result);
                }
                return result;
            }

            public Class[] getAdapterList() {
                return new Class[]{DisplayableData.class};
            }
        };
        UsagePlugin.getOfferingRegistry().findOrRegisterOffering(OFFERING_ID, Messages.getString("ToolName.NPSEnablement"));
        AdapterManager.getDefault().registerFactory(adapterFactory, Command.class.getName());
        super.start(context);
        this.getPluginPreferences().getString("FOO");
        TrayDialog.setDialogHelpAvailable((boolean)true);
        if (DEBUG_GENERAL) {
            logger.setLevel(Level.FINER);
        }
        logger.setUseParentHandlers(true);
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                window.addPerspectiveListener(new IPerspectiveListener(){

                    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                        if ("com.ibm.cics.ia.ui.perspective".equals(perspective.getId())) {
                            page.setEditorAreaVisible(true);
                            if ("reset".equals(changeId)) {
                                IEditorReference[] editors;
                                IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
                                int n = editors.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IEditorReference iEditorReference = iEditorReferenceArray[n2];
                                    page.closeEditor(iEditorReference.getEditor(false), iEditorReference.getEditor(false) instanceof ISaveablePart);
                                    ++n2;
                                }
                            }
                        }
                    }

                    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    }
                });
            }
        });
        Debug.exit((Logger)logger, (String)Activator.class.getName(), (String)"start");
    }

    public void stop(BundleContext context) throws Exception {
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static IViewPart getPropertiesView() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find properties view", (Throwable)e);
            return null;
        }
    }

    public static void executeSearch(Command aCommand) {
        Debug.enter((Logger)logger, (String)Activator.class.getName(), (String)"executeSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Activator.getDefault().ensureConnected();
        IEditorPart editor = Activator.openEditor(QueryResultsView.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.queryresultsview", false);
        if (editor != null) {
            ((QueryResultsView)editor).cancelSearch(aCommand);
            ((QueryResultsView)editor).executeSearch(aCommand);
        }
        Debug.exit((Logger)logger, (String)Activator.class.getName(), (String)"executeSearch");
    }

    public static void executeSyncSearch(final Command aCommand) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)Activator.class.getName(), (String)"executeSyncSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
                Activator.getDefault().ensureConnected();
                IEditorPart editor = Activator.openEditor(QueryResultsView.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.queryresultsview", false);
                if (editor != null) {
                    ((QueryResultsView)editor).cancelSearch(aCommand);
                    ((QueryResultsView)editor).executeSearch(aCommand);
                }
                Debug.exit((Logger)logger, (String)Activator.class.getName(), (String)"executeSyncSearch");
            }
        });
    }

    public static IEditorPart getEmptyQueryResultView() {
        IEditorPart editor = Activator.openEditor(QueryResultsView.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.queryresultsview", false);
        if (editor != null) {
            ((QueryResultsView)editor).showDummyTree();
        }
        return editor;
    }

    public static ProgramExplorer getProgramExplorer() {
        try {
            Activator.getDefault().ensureConnected();
            return (ProgramExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.ia.ui.programexplorer");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find program explorer", (Throwable)e);
            return null;
        }
    }

    public static TransactionExplorer getTransactionExplorer() {
        try {
            return (TransactionExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.ia.ui.transactionexplorer");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find transaction explorer", (Throwable)e);
            return null;
        }
    }

    public static WebserviceExplorer getWebserviceExplorer() {
        try {
            return (WebserviceExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.ia.ui.webserviceexplorer");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find webservice explorer", (Throwable)e);
            return null;
        }
    }

    public void init(IWorkbenchWindow workbenchWindow) {
    }

    public void setSystemActiveProperty() {
        boolean wsaaActive = IAUtilities.hasContent((String)IAPlugin.getDefault().getPluginPreferences().getString("WSAA_SERVER_NAME"));
        if (wsaaActive) {
            System.setProperty(WSAA_ACTIVE, "true");
            IAPlugin.getDefault().getPluginPreferences().setValue(WSAA_ACTIVE, "true");
            IAPlugin.getDefault().savePluginPreferences();
        } else {
            System.setProperty(WSAA_ACTIVE, "false");
            IAPlugin.getDefault().getPluginPreferences().setValue(WSAA_ACTIVE, "false");
            IAPlugin.getDefault().savePluginPreferences();
        }
    }

    public synchronized void ensureConnected() {
        IConnectionState connectionState;
        Debug.enter((Logger)logger, (String)Activator.class.getName(), (String)"ensureConnected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        IConnectable resourceManager = connectionService.getConnectable("com.ibm.cics.ia.connection.db2");
        if (resourceManager.getConnection() == null && (connectionState = connectionService.getConnectionState("com.ibm.cics.ia.connection.db2")).getID() != null) {
            connectionService.connect(connectionState.getID());
        }
        Debug.exit((Logger)logger, (String)Activator.class.getName(), (String)"ensureConnected");
    }

    public static CollectionIdsView getCollectionIdsView() {
        try {
            Activator.getDefault().ensureConnected();
            return (CollectionIdsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.ia.ui.CollectionIdsView");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find affinity view", (Throwable)e);
            return null;
        }
    }

    public void setCollectionIdWidget(CollectionIdWidget widget) {
        this.collectionIdWidget = widget;
    }

    public CollectionIdWidget getCollectionIdWidget() {
        return this.collectionIdWidget;
    }

    public static ReportBrowser getReportBrowser() {
        try {
            return (ReportBrowser)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.ia.ui.ReportBrowser");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find report browser", (Throwable)e);
            return null;
        }
    }

    public static ResourceConnectionsView getResourceConnectionsView(IEditorInput input) {
        try {
            return (ResourceConnectionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, ResourceConnectionsView.ID);
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find Resource Connections View", (Throwable)e);
            return null;
        }
    }

    public static ResourceVisualizationView getResourceVisualizationView(IEditorInput input) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] editors = page.getEditorReferences();
            Object reference = null;
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                if (iEditorReference.getId().equals(ResourceVisualizationView.ID)) {
                    page.closeEditor(iEditorReference.getEditor(false), false);
                }
                ++n2;
            }
            return (ResourceVisualizationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, ResourceVisualizationView.ID);
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find Resource Visualization View", (Throwable)e);
            return null;
        }
    }

    public static ThreadsafeReportViewImpl getThreadsafeReportView() {
        IEditorReference[] editors;
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            if (iEditorReference.getId().equals("com.ibm.cics.ia.ui.ThreadsafeReportView")) {
                return (ThreadsafeReportViewImpl)iEditorReference.getEditor(true);
            }
            ++n2;
        }
        return null;
    }

    public static CommandFlowDiagram getCommandFlowDiagram(IEditorInput input) {
        try {
            IEditorReference[] editors;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                if (iEditorReference.getId().equals(CommandFlowDiagram.ID)) {
                    page.closeEditor(iEditorReference.getEditor(false), false);
                }
                ++n2;
            }
            return (CommandFlowDiagram)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, CommandFlowDiagram.ID);
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find Command Flow Diagram", (Throwable)e);
            return null;
        }
    }

    public static AffinityReportEditor getAffinityReportEditor(IEditorInput input) {
        try {
            return (AffinityReportEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, "com.ibm.cics.ia.ui.AffinityReportEditor");
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find Affinity Report Editor", (Throwable)e);
            return null;
        }
    }

    public static AffinityBuildEditor getAffinityBuildEditor(IEditorInput input) {
        try {
            return (AffinityBuildEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, "com.ibm.cics.ia.ui.AffinityBuildEditor");
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find Affinity Report Editor", (Throwable)e);
            return null;
        }
    }

    public static IViewPart findView(String id) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(id);
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find the view with id: " + id, (Throwable)e);
            return null;
        }
    }

    public static IViewPart showView(String id) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id);
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to initialize the view with id: " + id, (Throwable)e);
            return null;
        }
    }

    public static NavigatorView findNavigatorView() {
        try {
            return (NavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.ibm.cics.ia.ui.navigatorview");
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find navigator view", (Throwable)e);
            return null;
        }
    }

    public static IAOperationsView showIAOperationsView() {
        try {
            return (IAOperationsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.ia.ui.IAOperationsView");
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to find IAOperations view", (Throwable)e);
            return null;
        }
    }

    public static IAOperationsView findIAOperationsView() {
        try {
            return (IAOperationsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.ibm.cics.ia.ui.IAOperationsView");
        }
        catch (Exception e) {
            IAPlugin.getDefault().logError("Unable to find IAOperations view", (Throwable)e);
            return null;
        }
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId, boolean ensureConnected) {
        if (ensureConnected) {
            Activator.getDefault().ensureConnected();
        }
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, editorId);
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Unable to open editor with ID \"" + editorId + "\"", (Throwable)e);
            return null;
        }
    }

    public static IEditorPart findEditor(IEditorInput editorInput) {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(editorInput);
    }
}

