/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.query.Query;
import com.ibm.cics.ia.query.QueryResults;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.QueryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QueryTreeController {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryTreeController.class.getPackage().getName());
    private List checkedQueries = new ArrayList();
    public static final String IRESOURCE = "IRESOURCE";
    private static final String CHILD_RESOURCES_TO_ITEMS = "CHILD_RESOURCES_TO_ITEMS";
    private Tree tree;
    private List listeners = new ArrayList();
    private Map dataToItems = new HashMap();
    private Map containersToItems = new HashMap();
    private Map filesToTreeItems = new HashMap();
    private Object sourceData;
    private TreeItem rootItem;

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void setTree(Tree aTree) {
        this.tree = aTree;
    }

    public void setRootItem(TreeItem root) {
        this.rootItem = root;
    }

    public void refresh() {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.dataToItems.clear();
        this.containersToItems.clear();
        QueryManager queryManager = QueryManager.getSingleton();
        queryManager.refresh();
        final IFolder queriesFolder = queryManager.getQueriesFolder();
        JobWithCancelingSupport job = new JobWithCancelingSupport(Messages.getString("QueryTreeController.refreshingQueriesJob0")){

            protected void cancelingSub() {
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"QueryTreeController.refresh().JobWithCancelingSupport", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                try {
                    queriesFolder.refreshLocal(2, monitor);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"QueryTreeController.refresh().JobWithCancelingSupport.runSub().Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            QueryTreeController.this.processQueriesFolder((IContainer)queriesFolder, null);
                            if (QueryTreeController.this.rootItem == null && QueryTreeController.this.tree != null && !QueryTreeController.this.tree.isDisposed()) {
                                TreeItem[] rootItems = QueryTreeController.this.tree.getItems();
                                int i = 0;
                                while (i < Math.min(4, rootItems.length)) {
                                    rootItems[i].setExpanded(true);
                                    ++i;
                                }
                                TreeItem queryTreeItem = (TreeItem)QueryTreeController.this.dataToItems.get(QueryTreeController.this.sourceData);
                                if (queryTreeItem != null) {
                                    QueryTreeController.this.tree.showItem(queryTreeItem);
                                    queryTreeItem.setChecked(true);
                                }
                            }
                            Debug.exit((Logger)logger, (String)"QueryTreeController.refresh().JobWithCancelingSupport.runSub().Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        }
                    });
                }
                catch (CoreException e) {
                    Debug.warning((Logger)logger, (String)"QueryTreeController.refresh().JobWithCancelingSupport", (String)"runSub", (String)"Error refreshing queries", (Throwable)e);
                    Debug.exit((Logger)logger, (String)"QueryTreeController.refresh().JobWithCancelingSupport", (String)"runSub", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "return ERROR"});
                    return new Status(4, "com.ibm.cics.ia.ui", "Error refreshing queries", (Throwable)e);
                }
                Debug.exit((Logger)logger, (String)"QueryTreeController.refresh().JobWithCancelingSupport", (String)"runSub", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "return OK_STATUS"});
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public TreeItem refresh(IContainer container, String itemName) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"refresh", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "container: " + (container == null ? container : container.getName()), "itemName: " + itemName});
        TreeItem containerItem = (TreeItem)this.containersToItems.get(container);
        this.processQueriesFolder(container, containerItem);
        TreeItem result = null;
        TreeItem[] items = containerItem.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(itemName)) {
                result = items[i];
                break;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"refresh", (Object)("result: " + (result == null ? result : result.getText())));
        return result;
    }

    private void processQueriesFolder(IContainer queriesFolder, TreeItem parentItem) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"processQueriesFolder", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "queriesFolder: " + (queriesFolder == null ? queriesFolder : queriesFolder.getName()), "parentItem: " + (parentItem == null ? parentItem : parentItem.getText())});
        try {
            IResource[] resources = queriesFolder.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFolder) {
                    if (this.tree != null && !this.tree.isDisposed()) {
                        TreeItem folderItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                        folderItem.setImage(ImageFactory.getFolderImage());
                        folderItem.setText(resource.getName());
                        folderItem.setData(IRESOURCE, (Object)resource);
                        this.containersToItems.put(resource, folderItem);
                        Iterator iter = this.listeners.iterator();
                        IFolder folder = (IFolder)resource;
                        while (iter.hasNext()) {
                            ((Listener)iter.next()).queryFolderCreated((IContainer)folder, folderItem);
                        }
                        this.processQueriesFolder((IContainer)folder, folderItem);
                    }
                } else if (resource instanceof IFile) {
                    this.processXMLFile((IFile)resource, parentItem);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Debug.event((Logger)logger, (Level)Level.FINEST, (String)QueryTreeController.class.getName(), (String)"processQueriesFolder", (Object[])new String[]{e.toString(), "cause: " + e.getCause()});
            IAPlugin.getDefault().logError("Unable to load queries folder " + queriesFolder.getName(), (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"processQueriesFolder");
    }

    private void processXMLFile(IFile file, TreeItem parentItem) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"processXMLFile", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "file: " + (file == null ? file : file.getName()), "parentItem: " + (parentItem == null ? parentItem : parentItem.getText())});
        if ("xml".equals(file.getFileExtension().toLowerCase())) {
            Presentation presentationObject = QueryManager.getSingleton().getXMLQuery((IResource)file);
            if (presentationObject != null) {
                if (this.tree != null && !this.tree.isDisposed()) {
                    TreeItem treeItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                    treeItem.setImage(ImageFactory.getQueryImage());
                    treeItem.setText(presentationObject.getTitle());
                    treeItem.setData(IRESOURCE, (Object)file);
                    treeItem.setData((Object)presentationObject);
                    this.filesToTreeItems.put(file, treeItem);
                    this.dataToItems.put(presentationObject, treeItem);
                    Iterator iter = this.listeners.iterator();
                    while (iter.hasNext()) {
                        ((Listener)iter.next()).queryItemCreated(file, presentationObject, treeItem);
                    }
                    this.createQueryResultItems(treeItem, presentationObject, file);
                }
            } else {
                try {
                    file.delete(true, null);
                }
                catch (Exception ex) {
                    Debug.warning((Logger)logger, (String)QueryTreeController.class.getName(), (String)"processXMLFile", (String)"empty catch", (Throwable)ex);
                }
            }
        }
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"processXMLFile");
    }

    public void createQueryResultItems(TreeItem parentItem, Presentation presentationObject, IFile queryFile) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"createQueryResultItems", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "parentItem: " + (parentItem == null ? parentItem : parentItem.getText()), "presentationObject: " + (presentationObject == null ? presentationObject : presentationObject.getTitle()), "queryFile: " + (queryFile == null ? queryFile : queryFile.getName())});
        List<QueryResults> queryResultsList = QueryManager.getSingleton().getQueryResults(presentationObject);
        if (queryResultsList != null) {
            for (QueryResults queryResult : QueryManager.getSingleton().getQueryResults(presentationObject)) {
                this.createQueryResultItem(queryResult, parentItem);
            }
        }
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"createQueryResultItems");
    }

    public void createQueryResultItem(QueryResults queryResult, TreeItem queryTreeItem) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"createQueryResultItem", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "queryResult: " + (queryResult == null ? queryResult : queryResult.getName()), "queryTreeItem: " + (queryTreeItem == null ? queryTreeItem : queryTreeItem.getText())});
        TreeItem resultTreeItem = new TreeItem(queryTreeItem, 0);
        resultTreeItem.setText(queryResult.getDisplayName());
        resultTreeItem.setImage(ImageFactory.getQueryResultImage());
        resultTreeItem.setData((Object)queryResult);
        this.dataToItems.put(queryResult, resultTreeItem);
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"createQueryResultItem");
    }

    public void deleteQueryResultItem(QueryResults queryResult) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"deleteQueryResultItem", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "queryResult: " + (queryResult == null ? queryResult : queryResult.getName())});
        TreeItem queryResultItem = (TreeItem)this.dataToItems.get(queryResult);
        queryResultItem.dispose();
        this.dataToItems.remove(queryResult);
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"deleteQueryResultItem");
    }

    public void setSource(Object data) {
        Debug.enter((Logger)logger, (String)QueryTreeController.class.getName(), (String)"setSource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "data: " + data});
        if (this.dataToItems.isEmpty()) {
            this.sourceData = data;
        } else {
            TreeItem queryTreeItem = (TreeItem)this.dataToItems.get(data);
            this.tree.showItem(queryTreeItem);
        }
        Debug.exit((Logger)logger, (String)QueryTreeController.class.getName(), (String)"setSource");
    }

    public Query getInQuery() {
        return (Query)this.checkedQueries.get(0);
    }

    public TreeItem getContainerItem(IContainer aResource) {
        return (TreeItem)this.containersToItems.get(aResource);
    }

    public void setTreeItem(IContainer aResource, TreeItem item) {
        this.containersToItems.put(aResource, item);
    }

    public TreeItem getTreeItem(IResource resource) {
        TreeItem treeItem = (TreeItem)this.containersToItems.get(resource);
        if (treeItem == null) {
            treeItem = (TreeItem)this.filesToTreeItems.get(resource);
        }
        return treeItem;
    }

    public static interface Listener {
        public void queryFolderCreated(IContainer var1, TreeItem var2);

        public void queryItemCreated(IFile var1, Query var2, TreeItem var3);

        public void queryItemCreated(IFile var1, Presentation var2, TreeItem var3);
    }
}

