/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.controller.TreeFinder;
import com.ibm.cics.ia.ui.ExecutionTree;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExecutionTreeFinder
extends TreeFinder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ExecutionTreeFinder.class.getPackage().getName());
    private List searchResources;
    private ExecutionTree executionTree;

    public ExecutionTreeFinder(Tree resourcesTree, ToolItem searchNextItem, ToolItem searchPreviousItem, ExecutionTree executionTree) {
        super(resourcesTree, searchNextItem, searchPreviousItem);
        this.executionTree = executionTree;
    }

    public void setResources(List resources) {
        this.searchResources = resources;
    }

    @Override
    public void findMatchingItems() {
        Debug.enter((Logger)logger, (String)ExecutionTreeFinder.class.getName(), (String)"findMatchingItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)"ExecutionTreeFinder.findMatchingItems().Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                ExecutionTreeFinder.this.executionTree.populateExecutionTree();
                Debug.exit((Logger)logger, (String)"ExecutionTreeFinder.findMatchingItems().Runnable", (String)"run");
            }
        });
        this.matchingItems = new ArrayList();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.findMatchingItems(item);
            ++n2;
        }
        Debug.exit((Logger)logger, (String)ExecutionTreeFinder.class.getName(), (String)"findMatchingItems");
    }

    private void findMatchingItems(TreeItem treeItem) {
        Debug.enter((Logger)logger, (String)ExecutionTreeFinder.class.getName(), (String)"findMatchingItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Object resource = treeItem.getData("RESOURCE");
        if (resource == null) {
            "Foo".toString();
        }
        if (this.searchResources.contains(resource)) {
            this.matchingItems.add(treeItem);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.findMatchingItems(item);
            ++n2;
        }
        Debug.exit((Logger)logger, (String)ExecutionTreeFinder.class.getName(), (String)"findMatchingItems");
    }
}

