/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.ui.ImageFactory;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;

public class DisplayableData {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Image image;
    private String description;
    private int size;
    private int status = -1;

    public String getDescription() {
        if (this.status == 4) {
            return MessageFormat.format(Messages.getString("DisplayableData.description"), this.description);
        }
        if (this.status == 2) {
            return MessageFormat.format(Messages.getString("DisplayableData.errordescription"), this.description);
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setStatus(int aStatus) {
        this.status = aStatus;
    }

    public static DisplayableData getDisplayableData(IAdaptable anAdaptable) {
        return (DisplayableData)anAdaptable.getAdapter(DisplayableData.class);
    }

    public static DisplayableData setData(IAdaptable adaptable, Image image, String name) {
        DisplayableData displayableData = (DisplayableData)adaptable.getAdapter(DisplayableData.class);
        displayableData.setImage(image);
        displayableData.setDescription(name);
        return displayableData;
    }

    public static void decorateImage(IAdaptable anAdaptable, Image stopImageOverlay) {
        DisplayableData displayableData = DisplayableData.getDisplayableData(anAdaptable);
        Image existingImage = displayableData.getImage();
        Image overlaidImage = ImageFactory.getOverlaidImage(existingImage, stopImageOverlay);
        displayableData.setImage(overlaidImage);
    }
}

