/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.DataSet;
import com.ibm.cics.zos.model.DataSetBuilder;
import com.ibm.cics.zos.model.DataSetMemberBuilder;
import com.ibm.cics.zos.model.IDataSetBuilder;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.editor.jcl.SubmissableHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchPart;

public class CPSMDeploymentController
extends Job {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String jcl = "//BTCHUPD EXEC PGM=EYU9XDBC,REGION=2048K\n//STEPLIB  DD  DSN=_loadlib_,\n//             DISP=SHR\n//         DD  DSN=_authlib_,\n//             DISP=SHR\n//SYSPRINT DD SYSOUT=*\n//SYSABEND DD SYSOUT=*\n//SYSIN DD *\nCMASNAME(_cmasname_)\nEXECUTE\nINPUTDSN(_datasetname_)\nINPUTMEMBER(_membername_)\nOUTPUTUSER(_outputuser_)\nPRINTNODE(_printnode_)\n/*\n";
    private String dataSetName;
    private String memberName;
    private String cmasName;
    private String outputUser;
    private String printNode;
    private AffinityBuilderOutput affinityBuilderOutput;
    private IWorkbenchPart part;
    private static final Logger logger = Logger.getLogger(CPSMDeploymentController.class.getPackage().getName());

    public CPSMDeploymentController(IWorkbenchPart part, AffinityBuilderOutput affinityBuilderOutput, String dataSetName, String memberName, String cmasName, String outputUser, String printNode) {
        super(Messages.getString("CPSM.Deployment.TaskName"));
        this.part = part;
        this.affinityBuilderOutput = affinityBuilderOutput;
        this.dataSetName = dataSetName;
        this.memberName = memberName;
        this.cmasName = cmasName;
        this.outputUser = outputUser;
        this.printNode = printNode;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"run", (Object)("ThreadId: " + Thread.currentThread().getId()));
        try {
            monitor.beginTask(Messages.getString("CPSM.Deployment.TaskName"), 100);
            monitor.worked(0);
            this.save();
            monitor.worked(50);
            final String jcl = this.affinityBuilderOutput.getJcl();
            this.part.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SubmissableHandler.submit((String)jcl, (IWorkbenchPart)CPSMDeploymentController.this.part);
                }
            });
            monitor.worked(100);
            monitor.done();
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"run", (String)"error message shown", (Throwable)e);
            this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox box = new MessageBox(CPSMDeploymentController.this.part.getSite().getShell(), 33);
                    box.setMessage(e.getLocalizedMessage());
                    box.setText(Messages.getString("CPSM.Deployment.Error"));
                    box.open();
                }
            });
        }
        Debug.exit((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"run", (Object)"return OK_STATUS");
        return Status.OK_STATUS;
    }

    public static InputStream toInputStream(String fileContents) {
        final StringReader reader = new StringReader(fileContents);
        InputStream result = new InputStream(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }
        };
        return result;
    }

    public String generateJCL() {
        Debug.enter((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"generateJCL", (Object)("ThreadID: " + Thread.currentThread().getId()));
        StringBuilder sb = new StringBuilder();
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String jobcard = prefs.getString("CPSM_DEPLOYMENT_JOB_CARD");
        sb.append(jobcard);
        String jclText = jcl;
        jclText = jclText.replace("_loadlib_", prefs.getString("CPSM_DEPLOYMENT_LOADLIB"));
        jclText = jclText.replace("_authlib_", prefs.getString("CPSM_DEPLOYMENT_AUTHLIB"));
        jclText = jclText.replace("_datasetname_", this.dataSetName);
        jclText = jclText.replace("_membername_", this.memberName);
        jclText = jclText.replace("_cmasname_", this.cmasName);
        jclText = jclText.replace("_outputuser_", this.outputUser);
        jclText = jclText.replace("_printnode_", this.printNode);
        sb.append(jclText);
        Debug.exit((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"generateJCL", (Object)("return: " + sb.toString()));
        return sb.toString();
    }

    public void save() {
        Debug.enter((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"save", (Object)("ThreadID: " + Thread.currentThread().getId()));
        if (IAUtilities.hasContent((String)this.dataSetName) && IAUtilities.hasContent((String)this.memberName)) {
            try {
                PartitionedDataSet dataSet = null;
                Member member = null;
                try {
                    dataSet = (PartitionedDataSet)ZOSActivator.getZOSConnectable().getDataSet(this.dataSetName);
                }
                catch (FileNotFoundException ex) {
                    Debug.warning((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"save", (String)"getDataSet(dataSetName) error", (Throwable)ex);
                    DataSetBuilder builder = new DataSetBuilder(this.dataSetName);
                    builder.datasetType = DataSet.NewDatasetType.PDS;
                    builder.spaceUnits = DataSet.SpaceUnits.BLOCKS;
                    builder.primaryAllocation = 300L;
                    builder.secondaryAllocation = 100L;
                    builder.directoryBlocks = 20L;
                    builder.format = DataSet.RecordFormat.FB;
                    builder.recordLength = 80L;
                    builder.blockSize = 800L;
                    dataSet = (PartitionedDataSet)ZOSActivator.getZOSConnectable().create((IDataSetBuilder)builder);
                }
                try {
                    member = ZOSActivator.getZOSConnectable().getDataSetMember(dataSet, this.memberName);
                }
                catch (FileNotFoundException e) {
                    Debug.warning((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"save", (String)("memberName = " + this.memberName), (Throwable)e);
                    DataSetMemberBuilder memberBuilder = new DataSetMemberBuilder(dataSet, this.memberName);
                    member = ZOSActivator.getZOSConnectable().create(memberBuilder);
                }
                catch (ConnectionException ex) {
                    Debug.warning((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"save", (String)Messages.getString("CPSM.Deployment.Error"), (Throwable)ex);
                    this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox box = new MessageBox(CPSMDeploymentController.this.part.getSite().getShell(), 33);
                            box.setMessage(ex.getLocalizedMessage());
                            box.setText(Messages.getString("CPSM.Deployment.Error"));
                            box.open();
                        }
                    });
                }
                if (member != null) {
                    ZOSActivator.getZOSConnectable().save((DataEntry)member, CPSMDeploymentController.toInputStream(this.affinityBuilderOutput.toString()));
                }
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"save", (String)Messages.getString("CPSM.Deployment.Error"), (Throwable)e);
                this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (e.getLocalizedMessage() != null) {
                            MessageBox box = new MessageBox(CPSMDeploymentController.this.part.getSite().getShell(), 33);
                            box.setMessage(e.getLocalizedMessage());
                            box.setText(Messages.getString("CPSM.Deployment.Error"));
                            box.open();
                        }
                    }
                });
            }
        }
        Debug.exit((Logger)logger, (String)CPSMDeploymentController.class.getName(), (String)"save");
    }
}

