/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.storedproc;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.command.StoredProcParameter;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.Messages;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;

public class ProcedureCIUSPDPG
extends StoredProcedureDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NAME = "CIUSPDPG";
    private static final String IN_CALLTYPE = "IN_CALLTYPE";
    private static final String IN_COLLID = "IN_COLLID";
    private static final String IN_APPLID = "IN_APPLID";
    private static final String IN_PNAME = "IN_PNAME";
    private static final String IN_TNAME = "IN_TNAME";
    public static final String PCOUNT = "PCOUNT";
    public static final String RC = "RC";
    public static final String ERRMSG = "ERRMSG";
    public static final String LIST_APPLICATIONS = "L";
    public static final String DELETE_APPLICATION = "D";
    private Program program;
    private Region region;
    private StoredProcedure selectionObject;

    public ProcedureCIUSPDPG() {
        this.name = NAME;
        this.parameters = new HashMap();
        int paramCounter = 1;
        while (paramCounter <= 5) {
            this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        }
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
        this.resultSetCount = 3;
    }

    public SelectionObject getSelectionObject(String callType, String appId, String pName, String tName) {
        if (this.selectionObject != null) {
            return this.selectionObject;
        }
        this.selectionObject = PresentationFactory.getInstance().createStoredProcedure(this.name, null);
        String collectionId = StringUtil.isEmpty((String)IASQLCommand.getCollectionId()) ? "%" : IASQLCommand.getCollectionId();
        String applId = StringUtil.isEmpty((String)appId) ? "%" : appId;
        this.selectionObject.addInputParameter(IN_CALLTYPE, callType, ColumnReference.DataType.String);
        this.selectionObject.addInputParameter(IN_COLLID, collectionId, ColumnReference.DataType.String);
        this.selectionObject.addInputParameter(IN_APPLID, applId, ColumnReference.DataType.String);
        this.selectionObject.addInputParameter(IN_PNAME, pName, ColumnReference.DataType.String);
        this.selectionObject.addInputParameter(IN_TNAME, tName, ColumnReference.DataType.String);
        this.selectionObject.addOutputParameter(PCOUNT, ColumnReference.DataType.Integer);
        this.selectionObject.addOutputParameter(RC, ColumnReference.DataType.Integer);
        this.selectionObject.addOutputParameter(ERRMSG, ColumnReference.DataType.String);
        return this.selectionObject;
    }

    public boolean isAvailable(final String pName, final String tName) {
        boolean result = true;
        StoredProcedureCommand command = new StoredProcedureCommand(){

            public Object processRow(ResultSet resultSet) throws SQLException {
                return resultSet.getString(1);
            }

            public SelectionObject getSelectionObject() {
                return ProcedureCIUSPDPG.this.getSelectionObject(ProcedureCIUSPDPG.LIST_APPLICATIONS, "%", pName, tName);
            }
        };
        command.setCategory("com.ibm.cics.ia.connection.db2");
        command.setAsync(false);
        command.start();
        if (command.status() != 1 && command.status() != 3) {
            if (command.status() == 2) {
                MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeWizard.procedureExecuteError.message"), (int)1);
                return false;
            }
            result = false;
        }
        return result;
    }
}

