/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.storedproc;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcParameter;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.util.HashMap;
import java.util.logging.Logger;

public class ProcedureCIUSPDEL
extends StoredProcedureDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProcedureCIUSPDEL.class.getPackage().getName());
    public static final String DELETE = "D";

    public ProcedureCIUSPDEL() {
        this.name = "CIUSPDEL";
        this.parameters = new HashMap();
        this.resultSetCount = 0;
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        int integerParameterNumber = Version.getInstance().getDBVersion() < 5300 ? 16 : 17;
        int parameterCount = this.resultSetCount + integerParameterNumber;
        while (this.resultSetCount < parameterCount) {
            this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        }
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
    }

    public SelectionObject getSelectionObject(String callType, String collectionId) {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPDEL.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StoredProcedure result = PresentationFactory.getInstance().createStoredProcedure(this.name, null);
        String safeCallType = IAUtilities.hasContent(callType) ? callType : "";
        String safeCollectionId = IAUtilities.hasContent(collectionId) ? collectionId : "";
        result.addInputParameter("IN_CALLTYPE", callType, ColumnReference.DataType.String);
        result.addInputParameter("IN_COLLECTION_ID", safeCollectionId, ColumnReference.DataType.String);
        result.addOutputParameter("CICS_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("DB2_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("MQ_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("IMS_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("PROGRAM_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("TRANSID_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("TSQUEUE_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("TDQUEUE_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("WEBSERV_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("FILE_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("EXIT_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("EVENT_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("REGION_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("NATURAL_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("RESOURCE_COUNT", ColumnReference.DataType.Integer);
        if (Version.getInstance().getDBVersion() >= 5300) {
            result.addOutputParameter("CHAIN_COUNT", ColumnReference.DataType.Integer);
        }
        result.addOutputParameter("RC", ColumnReference.DataType.Integer);
        result.addOutputParameter("ERRMSG", ColumnReference.DataType.String);
        Debug.exit((Logger)logger, (String)ProcedureCIUSPDEL.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

