/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.storedproc;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.command.StoredProcParameter;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcedureCIUSPAPP
extends StoredProcedureDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProcedureCIUSPAPP.class.getPackage().getName());
    public static final String DEFINED_APPLICATIONS = "LIST";
    public static final String TRANPROG_NAMED_APPLICATION_RESTYPE = "DEFN";
    public static final String RESTYPE_PROGRAM = "PROGRAM";
    public static final String RESTYPE_TRANSID = "TRANSID";

    public ProcedureCIUSPAPP() {
        this.name = "CIUSPAPP";
        this.parameters = new HashMap();
        this.parameters.put(1, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(2, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(3, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(4, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(5, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        this.resultSetCount = 5;
    }

    public SelectionObject getSelectionObject(String callType, String appCode, String resType) {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPAPP.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StoredProcedure result = PresentationFactory.getInstance().createStoredProcedure(this.name, null);
        String safeAppCode = IAUtilities.hasContent(appCode) ? appCode : "";
        String safeResType = IAUtilities.hasContent(resType) ? resType : "";
        result.addInputParameter("CALLTYPE", callType, ColumnReference.DataType.String);
        result.addInputParameter("APPCODE", safeAppCode, ColumnReference.DataType.String);
        result.addInputParameter("RESTYPE", safeResType, ColumnReference.DataType.String);
        result.addOutputParameter("ERRMSG", ColumnReference.DataType.String);
        result.addOutputParameter("RC", ColumnReference.DataType.Integer);
        Debug.exit((Logger)logger, (String)ProcedureCIUSPAPP.class.getName(), (String)"getSelectionObject");
        return result;
    }

    public boolean isAvailable() {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPAPP.class.getName(), (String)"isAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean result = true;
        StoredProcedureCommand command = new StoredProcedureCommand(){

            public Object processRow(ResultSet resultSet) throws SQLException {
                return resultSet.getString(1);
            }

            public SelectionObject getSelectionObject() {
                return ProcedureCIUSPAPP.this.getSelectionObject(ProcedureCIUSPAPP.DEFINED_APPLICATIONS, "", "");
            }
        };
        command.setCategory("com.ibm.cics.ia.connection.db2");
        command.setAsync(false);
        command.start();
        if (command.status() != 1 && command.status() != 3) {
            Throwable t;
            if (command.status() == 2 && (t = command.getError()) instanceof SQLException) {
                Debug.warning((Logger)logger, (String)ProcedureCIUSPAPP.class.getName(), (String)"isAvailable", (Throwable)t, new HashMap());
                SQLException sqle = (SQLException)t;
                if (DBUtilities.isStoredProcedureAbsent((SQLException)sqle) && Version.getInstance().getDBVersion() >= 3200) {
                    logger.log(Level.WARNING, String.valueOf(Messages.getString(String.valueOf(this.name) + ".ProcedureExpected")) + sqle);
                }
            }
            result = false;
        }
        Debug.exit((Logger)logger, (String)ProcedureCIUSPAPP.class.getName(), (String)"isAvailable");
        return result;
    }
}

