/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.runtime;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.ia.query.AdjustableSqlAttributes;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.runtime.VersionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class Version {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Version.class.getPackage().getName());
    public static final int CIU_31_VERSION = 3100;
    public static final int CIU_32_VERSION = 3200;
    public static final int CIU_51_VERSION = 5100;
    public static final int CIU_511_VERSION = 5110;
    public static final int CIU_52_VERSION = 5200;
    public static final int CIU_53_VERSION = 5300;
    public static final int CIU_55_VERSION = 5500;
    public static final int CIU_61_VERSION = 6100;
    public static final int CIU_EXP_MIN_DB_VER = 3100;
    public static final int PLUGIN_CURRENT_VER = 6100;
    public static final String CIU_31_DB_APAR_LEVEL_PM65421 = "PM65421";
    public static final String CIU_32_DB_APAR_LEVEL_PM55568 = "PM55568";
    public static final String CIU_511_DB_APAR_LEVEL_PI22815 = "PI22815";
    private static Version instance = new Version();
    private boolean dbChecked = false;
    private boolean dbValid = false;
    private int dbVersion = 0;
    private String dbAparLevel = "";
    private static List<AdjustableSqlAttributes> adjustableSqlAttributes = new LinkedList<AdjustableSqlAttributes>();

    static {
        adjustableSqlAttributes.add(SQLDefinitions.CMDFLOW_ATTRIBUTES);
        adjustableSqlAttributes.add(SQLDefinitions.CICS_ATTRIBUTES);
        adjustableSqlAttributes.add(SQLDefinitions.DB2_ATTRIBUTES);
        adjustableSqlAttributes.add(SQLDefinitions.IMS_ATTRIBUTES);
        adjustableSqlAttributes.add(SQLDefinitions.MQ_ATTRIBUTES);
        adjustableSqlAttributes.add(SQLDefinitions.NATURAL_ATTRIBUTES);
        adjustableSqlAttributes.add(SQLDefinitions.SCANNER_DETAILS_ATTRIBUTES);
    }

    private Version() {
    }

    public static Version getInstance() {
        return instance;
    }

    public int getDBVersion() {
        return this.dbVersion;
    }

    public String getDbAparLevel() {
        return this.dbAparLevel;
    }

    public synchronized void reset() {
        this.dbChecked = false;
        this.dbValid = false;
        this.dbVersion = 0;
    }

    public synchronized boolean isDBValid() throws VersionException {
        Debug.enter((Logger)logger, (String)Version.class.getName(), (String)"isDBValid", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.dbChecked) {
            try {
                this.dbValid = this.checkVersion();
            }
            catch (SQLException e) {
                Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"isDBValid", (Throwable)e, new HashMap());
            }
            catch (VersionException ve) {
                Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"isDBValid", (Throwable)ve, new HashMap());
                throw ve;
            }
            this.dbChecked = true;
        }
        Debug.exit((Logger)logger, (String)Version.class.getName(), (String)"isDBValid");
        return this.dbValid;
    }

    private boolean checkVersion() throws SQLException, VersionException {
        Debug.enter((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean result = false;
        DB2Host host = DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2");
        if (host != null && host.getConnectionStatus() == DB2Host.CONNECTED) {
            Connection connection = null;
            try {
                connection = host.getDB2Connection();
            }
            catch (SQLException e) {
                Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Throwable)e, new HashMap());
            }
            catch (ConnectionException e) {
                Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Throwable)e, new HashMap());
            }
            if (connection != null) {
                Debug.enter((Logger)logger, (String)Version.class.getName(), (String)"checkVersion");
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    statement = connection.createStatement();
                    String allDataQuery = "SELECT * FROM $tableName.CIU_VERSION";
                    String allDataQueryWithSchema = allDataQuery.replace("$tableName", host.getSchema());
                    resultSet = statement.executeQuery(allDataQueryWithSchema);
                    if (!resultSet.next()) {
                        resultSet.close();
                        VersionException ex = new VersionException(MessageFormat.format(Messages.getString("Host.versionTableMessage"), "CIU", host.getSchema()));
                        Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Throwable)ex, new HashMap());
                        throw ex;
                    }
                    resultSet.close();
                    statement = connection.createStatement();
                    String expMinVerQuery = "SELECT EXP_MIN_VER FROM $tableName.CIU_VERSION";
                    String expMinVerQueryWithSchema = expMinVerQuery.replace("$tableName", host.getSchema());
                    resultSet = statement.executeQuery(expMinVerQueryWithSchema);
                    resultSet.next();
                    int minDBLevel = Integer.parseInt(resultSet.getString(1));
                    if (6100 < minDBLevel) {
                        String verCustDescQuery = "SELECT VER_CUST_DESC FROM $tableName.CIU_VERSION";
                        String verCustDescQueryWithSchema = verCustDescQuery.replace("$tableName", host.getSchema());
                        resultSet = statement.executeQuery(verCustDescQueryWithSchema);
                        resultSet.next();
                        String message = resultSet.getString(1).trim();
                        resultSet.close();
                        VersionException ex = new VersionException(message);
                        Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Throwable)ex, new HashMap());
                        throw ex;
                    }
                    resultSet.close();
                    statement = connection.createStatement();
                    String expLatestVerQuery = "SELECT EXP_LATEST_VER, DB_APAR_LEVEL FROM $tableName.CIU_VERSION";
                    String expLatestVerQueryWithSchema = expLatestVerQuery.replace("$tableName", host.getSchema());
                    resultSet = statement.executeQuery(expLatestVerQueryWithSchema);
                    resultSet.next();
                    this.dbVersion = Integer.parseInt(resultSet.getString(1));
                    this.dbAparLevel = resultSet.getString(2);
                    for (AdjustableSqlAttributes attrs : adjustableSqlAttributes) {
                        attrs.adjustToCurrentVersion();
                    }
                    result = true;
                }
                catch (SQLException e) {
                    Debug.error((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Throwable)e);
                    IAPlugin.getDefault().logError("Unable to check version table", e);
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e1) {
                            Debug.warning((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", (Throwable)e1, new HashMap());
                        }
                    }
                    throw e;
                }
            }
            return false;
        }
        Debug.exit((Logger)logger, (String)Version.class.getName(), (String)"checkVersion", null);
        return result;
    }

    public static String getVersionName(int version) {
        switch (version) {
            case 3100: {
                return Messages.getString("Version.3100");
            }
            case 3200: {
                return Messages.getString("Version.3200");
            }
            case 5100: {
                return Messages.getString("Version.5100");
            }
            case 5110: {
                return Messages.getString("Version.5110");
            }
            case 5200: {
                return Messages.getString("Version.5200");
            }
            case 5300: {
                return Messages.getString("Version.5300");
            }
            case 5500: {
                return Messages.getString("Version.5500");
            }
            case 6100: {
                return Messages.getString("Version.6100");
            }
        }
        return Messages.getString("Version.unknown");
    }

    public String getName() {
        return String.valueOf(Version.getVersionName(this.dbVersion)) + ", DB APAR LEVEL [" + this.dbAparLevel + "]";
    }
}

