/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;

public class QueryResults {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryResults.class.getPackage().getName());
    private List interactions = Collections.EMPTY_LIST;
    private Presentation presentationObject;
    private String[] columnNames;
    private String resultName = "";
    private String scope = null;
    private Date date;
    private String[] userColumnNames;

    public List getInteractions() {
        return this.interactions;
    }

    public Presentation getQuery() {
        return this.presentationObject;
    }

    public String getName() {
        return this.resultName;
    }

    public void setName(String aName) {
        this.resultName = aName;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getScope() {
        return this.scope;
    }

    public String getDisplayName() {
        String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getDefault());
        return String.valueOf(this.getName()) + " : " + dateFormat.format(this.getDate());
    }

    public QueryResults(String name, List interactions, Presentation aPresentation) {
        this.presentationObject = aPresentation;
        this.setName(name);
        this.setDate(Calendar.getInstance(TimeZone.getDefault()).getTime());
        this.interactions = interactions;
    }

    public QueryResults(String name, List interactions, Presentation aPresentation, String scope) {
        this.presentationObject = aPresentation;
        this.setName(name);
        this.setDate(Calendar.getInstance(TimeZone.getDefault()).getTime());
        this.interactions = interactions;
        this.scope = scope;
    }

    public String[] getColumnNames() {
        Debug.enter((Logger)logger, (String)QueryResults.class.getName(), (String)"getColumnNames", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.columnNames == null) {
            List columns = this.presentationObject.getSelection().getSelect().getColumns();
            Iterator iter = columns.iterator();
            String[] newColumnNames = new String[columns.size()];
            int i = 0;
            while (iter.hasNext()) {
                newColumnNames[i] = ((ColumnReference)iter.next()).getColumnName();
                ++i;
            }
            this.columnNames = newColumnNames;
        }
        Debug.exit((Logger)logger, (String)QueryResults.class.getName(), (String)"getColumnNames", (Object)("columnNames" + Arrays.toString(this.columnNames)));
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getUserColumnNames() {
        Debug.enter((Logger)logger, (String)QueryResults.class.getName(), (String)"getUserColumnNames", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.userColumnNames == null) {
            List columns = this.presentationObject.getSelection().getOrderBy().getColumns();
            Iterator iter = columns.iterator();
            String[] newColumnNames = new String[columns.size()];
            int i = 0;
            while (iter.hasNext()) {
                newColumnNames[i] = ((ColumnReference)iter.next()).getColumnName();
                ++i;
            }
            this.userColumnNames = newColumnNames;
        }
        Debug.exit((Logger)logger, (String)QueryResults.class.getName(), (String)"getUserColumnNames", (Object)("userColumnNames length: " + this.userColumnNames.length));
        return this.userColumnNames;
    }

    public void setUserColumnNames(String[] userColumnNames) {
        this.userColumnNames = userColumnNames;
    }
}

