/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class QueryResultRow {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryResultRow.class.getPackage().getName());
    private Object[] data;

    public void setData(Object[] data) {
        this.data = data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ResultRow(");
        int i = 0;
        while (i < this.data.length) {
            sb.append(this.data[i]);
            if (i < this.data.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    public static Map getRowsByColumn(List groupByColumns, Collection results) {
        Debug.enter((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRowsByColumn", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] cols = new String[groupByColumns.size()];
        int i = 0;
        while (i < groupByColumns.size()) {
            cols[i] = (String)groupByColumns.get(i);
            ++i;
        }
        Debug.exit((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRowsByColumn");
        return QueryResultRow.getRowsByColumn(cols, results);
    }

    public static Map getRowsByColumn(String[] groupByColumns, Collection results) {
        Debug.enter((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRowsByColumn", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int numberOfKeys = groupByColumns.length - 1;
        if (numberOfKeys < 1) {
            numberOfKeys = 1;
        }
        Object[] currentKeys = new Object[numberOfKeys];
        Map[] currentMaps = new Map[numberOfKeys];
        currentMaps[0] = new LinkedHashMap();
        ArrayList<Object> currentList = new ArrayList<Object>();
        for (QueryResultRow row : results) {
            int newKey = -1;
            int j = 0;
            while (j < numberOfKeys) {
                if (!row.data[j].equals(currentKeys[j])) {
                    newKey = j;
                    break;
                }
                ++j;
            }
            if (newKey != -1) {
                int i = newKey;
                while (i < numberOfKeys) {
                    LinkedHashMap newValue;
                    if (i == numberOfKeys - 1) {
                        currentList = new ArrayList();
                        currentMaps[i].put(row.data[i], currentList);
                        currentList.add(row.data[i + 1]);
                    } else if (i == 0) {
                        newValue = new LinkedHashMap();
                        currentMaps[0].put(row.data[i], newValue);
                        currentMaps[1] = newValue;
                    } else {
                        newValue = new LinkedHashMap();
                        currentMaps[i].put(row.data[i], newValue);
                        currentMaps[i + 1] = newValue;
                    }
                    currentKeys[i] = row.data[i];
                    ++i;
                }
                continue;
            }
            currentList.add(row.data[numberOfKeys]);
        }
        Debug.exit((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRowsByColumn");
        return currentMaps[0];
    }

    public static Map getRowsByColumn(String[] groupByColumns, Collection results, String hiddenColumn, List inlineColumns) {
        Debug.enter((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRowsByColumn", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int numberOfKeys = groupByColumns.length - 1 - inlineColumns.size();
        if (hiddenColumn != null) {
            --numberOfKeys;
        }
        Debug.exit((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRowsByColumn");
        return QueryResultRow.getRowsByColumn(groupByColumns, results);
    }

    public static List getRows(Collection results) {
        Debug.enter((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRows", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<Object> result = new ArrayList<Object>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            result.add(((QueryResultRow)iter.next()).data[0]);
        }
        Debug.exit((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRows");
        return result;
    }

    public static Map getRows(String[] groupByColumns, Collection results, String type) {
        Debug.enter((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRows", (Object)("Thread ID: " + Thread.currentThread().getId()));
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<Object> result = new ArrayList<Object>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            Object object = ((QueryResultRow)iter.next()).data[0];
            if (object == null) continue;
            result.add(object);
        }
        if (result.size() > 0) {
            map.put(type, result);
        }
        Debug.exit((Logger)logger, (String)QueryResultRow.class.getName(), (String)"getRows");
        return map;
    }

    public Object[] getData() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultRow)) {
            return false;
        }
        QueryResultRow other = (QueryResultRow)obj;
        return Arrays.equals(this.data, other.data);
    }

    public static List inFirstListNotInSecond(List firstList, List secondList) {
        Debug.enter((Logger)logger, (String)QueryResultRow.class.getName(), (String)"inFirstListNotInSecond", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<QueryResultRow> resourcesSecondList = new ArrayList<QueryResultRow>(secondList.size());
        for (QueryResultRow resultRow : secondList) {
            if (resourcesSecondList.contains(resultRow)) continue;
            resourcesSecondList.add(resultRow);
        }
        ArrayList<QueryResultRow> result = new ArrayList<QueryResultRow>(firstList.size() / 2);
        for (QueryResultRow resultRow : firstList) {
            if (resourcesSecondList.contains(resultRow)) continue;
            result.add(resultRow);
        }
        Debug.exit((Logger)logger, (String)QueryResultRow.class.getName(), (String)"inFirstListNotInSecond");
        return result;
    }
}

