/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.query.AdjustableSqlAttributes;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class QueryCompatibilityHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryCompatibilityHelper.class.getPackage().getName());
    private static AdjustableSqlAttributes adjustableAttributes;

    public static boolean isCompatible(Presentation presentation, StringBuilder reason) {
        Debug.enter((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"isCompatible", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "presentation: " + (presentation == null ? presentation : presentation.getTitle()), "reason: " + reason});
        boolean result = true;
        String queryType = presentation.getParameter("query_type");
        String columnPrefix = "Column.";
        adjustableAttributes = null;
        if (queryType.equals("com.ibm.cics.query.type.commandflow")) {
            adjustableAttributes = SQLDefinitions.CMDFLOW_ATTRIBUTES;
        } else if (queryType.equals("com.ibm.cics.query.type.cics")) {
            adjustableAttributes = SQLDefinitions.CICS_ATTRIBUTES;
            columnPrefix = "CICS.Column.";
        } else if (queryType.equals("com.ibm.cics.query.type.db2")) {
            adjustableAttributes = SQLDefinitions.DB2_ATTRIBUTES;
        } else if (queryType.equals("com.ibm.cics.query.type.ims")) {
            adjustableAttributes = SQLDefinitions.IMS_ATTRIBUTES;
        } else if (queryType.equals("com.ibm.cics.query.type.mq")) {
            adjustableAttributes = SQLDefinitions.MQ_ATTRIBUTES;
        } else if (queryType.equals("com.ibm.cics.query.type.natural")) {
            adjustableAttributes = SQLDefinitions.NATURAL_ATTRIBUTES;
        }
        if (adjustableAttributes != null) {
            Selection selection = presentation.getSelection();
            List<String> usedColumns = QueryCompatibilityHelper.getColumns(selection);
            Map<String, String> unsupportedAttributes = adjustableAttributes.checkCompatibility(usedColumns);
            result = QueryCompatibilityHelper.getCompatibilityInfo(columnPrefix, reason, unsupportedAttributes);
        }
        if (queryType.equals("com.ibm.cics.query.type.scanner") && Version.getInstance().getDBVersion() < 3200) {
            result = false;
            reason.append(Messages.getString("QueryCompatibilityHelper.unsupportedScannerQuery.text"));
        }
        Debug.exit((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"isCompatible", (Object)("result: " + result));
        return result;
    }

    public static boolean getCompatibilityInfo(String columnPrefix, StringBuilder reason, Map<String, String> unsupportedAttributes) {
        Debug.enter((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"getCompatibilityInfo", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "columnPrefix: " + columnPrefix, "reason: " + reason, "unsupportedAttributes size: " + unsupportedAttributes.size()});
        boolean result = true;
        if (unsupportedAttributes.size() > 0) {
            result = false;
            String columnRequrementPrefix = "QueryCompatibilityHelper.columnRequirement.text.";
            StringBuilder columnsRequirements = new StringBuilder("\n");
            StringBuilder columnList = new StringBuilder(" \n");
            Set<Map.Entry<String, String>> columnsSet = unsupportedAttributes.entrySet();
            Iterator<Map.Entry<String, String>> iter = columnsSet.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> columnRequirement = iter.next();
                columnList.append(Messages.getString(String.valueOf(columnPrefix) + columnRequirement.getKey()));
                if (iter.hasNext()) {
                    columnList.append(",\n");
                }
                columnsRequirements.append(Messages.getString(String.valueOf(columnPrefix) + columnRequirement.getKey()));
                columnsRequirements.append(" ");
                columnsRequirements.append(Messages.getString(String.valueOf(columnRequrementPrefix) + columnRequirement.getValue()));
                if (!iter.hasNext()) continue;
                columnsRequirements.append(",\n");
            }
            reason.append(MessageFormat.format(Messages.getString("QueryCompatibilityHelper.unsupportedFields.text"), Version.getInstance().getName(), columnList.toString()));
            IAPlugin.getDefault().logInformation(MessageFormat.format(Messages.getString("QueryCompatibilityHelper.columnRequirements.message.text"), columnsRequirements));
        }
        Debug.exit((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"getCompatibilityInfo", (Object)("result: " + result));
        return result;
    }

    private static List<String> getColumns(Selection selection) {
        Debug.enter((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"getColumns", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "selection: " + selection});
        ArrayList<String> result = new ArrayList<String>();
        for (ColumnReference column : selection.getSelect().getColumns()) {
            result.add(column.getColumnName());
        }
        ConstraintElement condition = selection.getCondition();
        result.addAll(QueryCompatibilityHelper.getColumns(condition));
        Debug.exit((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"getColumns", (Object)("result size: " + result.size()));
        return result;
    }

    private static List<String> getColumns(ConstraintElement constraint) {
        Debug.enter((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"getColumns", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "constraint: " + constraint});
        ArrayList<String> result = new ArrayList<String>();
        if (constraint instanceof Clause) {
            Clause clause = (Clause)constraint;
            for (ColumnReference column : clause.getColumns()) {
                result.add(column.getColumnName());
            }
        } else if (constraint instanceof ClauseGroup) {
            ClauseGroup clauseGroup = (ClauseGroup)constraint;
            for (ConstraintElement nextConstraint : clauseGroup.getClauses()) {
                result.addAll(QueryCompatibilityHelper.getColumns(nextConstraint));
            }
        }
        Debug.exit((Logger)logger, (String)QueryCompatibilityHelper.class.getName(), (String)"getColumns", (Object)new String[]{"result size: " + result.size(), result.toString()});
        return result;
    }
}

