/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.query.AdjustableSqlAttributes;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DbLevelAdjustableAttributes
extends AdjustableSqlAttributes {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DbLevelAdjustableAttributes.class.getPackage().getName());
    private DbLevelAttributes[] dbLevelAttributes;
    private String[] supersetAttributes;

    public DbLevelAdjustableAttributes(DbLevelAttributes ... dbLevelAttributes) {
        this.dbLevelAttributes = dbLevelAttributes;
    }

    @Override
    public final String[] getSupersetAttributes() {
        Debug.enter((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"getSupersetAttributes", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.supersetAttributes == null) {
            this.supersetAttributes = new String[0];
            DbLevelAttributes[] dbLevelAttributesArray = this.dbLevelAttributes;
            int n = this.dbLevelAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                DbLevelAttributes attrs = dbLevelAttributesArray[n2];
                this.supersetAttributes = IAUtilities.concat(this.supersetAttributes, new String[][]{attrs.attributes});
                ++n2;
            }
        }
        Debug.exit((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"getSupersetAttributes");
        return this.supersetAttributes;
    }

    @Override
    public final void adjustToCurrentVersion() {
        Debug.enter((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"adjustToCurrentVersion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int dbVersion = this.getCurrentVersion().getDBVersion();
        this.attributes = new String[0];
        DbLevelAttributes[] dbLevelAttributesArray = this.dbLevelAttributes;
        int n = this.dbLevelAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            DbLevelAttributes attrs = dbLevelAttributesArray[n2];
            if (attrs.dbLevel <= dbVersion) {
                this.attributes = IAUtilities.concat(this.attributes, new String[][]{attrs.attributes});
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"adjustToCurrentVersion");
    }

    @Override
    public Map<String, String> checkCompatibility(List<String> attributes) {
        Debug.enter((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"checkCompatibility", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> incompatibleAttributes = this.getIncompatibleAttributes(attributes);
        List<String> unknownAttributes = IAUtilities.subtract(incompatibleAttributes, this.getSupersetAttributes());
        for (String attribute : unknownAttributes) {
            result.put(attribute, "unknown");
        }
        for (String attribute : incompatibleAttributes) {
            int dbLevel = DbLevelAdjustableAttributes.getRequiredDbLevel(attribute, this.dbLevelAttributes);
            switch (dbLevel) {
                case -1: {
                    result.put(attribute, "unknown");
                    break;
                }
                case 3100: {
                    result.put(attribute, "ia31Specific");
                    break;
                }
                case 3200: {
                    result.put(attribute, "ia32Specific");
                    break;
                }
                case 5100: 
                case 5110: {
                    result.put(attribute, "ia51Specific");
                    break;
                }
                case 5200: {
                    result.put(attribute, "ia52Specific");
                }
            }
        }
        Debug.exit((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"checkCompatibility");
        return result;
    }

    public static final int getMinRequiredDbLevel(List<String> attributes, DbLevelAttributes ... dbLevelAttributes) {
        Debug.enter((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"getMinRequiredDbLevel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int dbLevel = -1;
        Arrays.sort(dbLevelAttributes);
        DbLevelAttributes[] dbLevelAttributesArray = dbLevelAttributes;
        int n = dbLevelAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            DbLevelAttributes attrs = dbLevelAttributesArray[n2];
            String[] stringArray = attrs.attributes;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String attr = stringArray[n4];
                if (attributes.contains(attr)) {
                    dbLevel = attrs.dbLevel;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"getMinRequiredDbLevel");
        return dbLevel;
    }

    public static final int getRequiredDbLevel(String attribute, DbLevelAttributes ... dbLevelAttributes) {
        Debug.enter((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"getRequiredDbLevel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int dbLevel = -1;
        Arrays.sort(dbLevelAttributes);
        DbLevelAttributes[] dbLevelAttributesArray = dbLevelAttributes;
        int n = dbLevelAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            DbLevelAttributes attrs = dbLevelAttributesArray[n2];
            String[] stringArray = attrs.attributes;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String attr = stringArray[n4];
                if (attr.equals(attribute)) {
                    dbLevel = attrs.dbLevel;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)DbLevelAdjustableAttributes.class.getName(), (String)"getRequiredDbLevel");
        return dbLevel;
    }

    public static class DbLevelAttributes
    implements Comparable<DbLevelAttributes> {
        private int dbLevel;
        private String[] attributes;

        public DbLevelAttributes(int dbLevel, String[] attributes) {
            this.dbLevel = dbLevel;
            this.attributes = attributes;
        }

        @Override
        public int compareTo(DbLevelAttributes other) {
            if (this.dbLevel < other.dbLevel) {
                return -1;
            }
            if (this.dbLevel == other.dbLevel) {
                return 0;
            }
            return 1;
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public int getDbLevel() {
            return this.dbLevel;
        }
    }
}

