/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.FindTableAttributesCommand;
import com.ibm.cics.ia.query.AdjustableSqlAttributes;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CommandFlowAttributes
extends AdjustableSqlAttributes {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandFlowAttributes.class.getPackage().getName());
    public static final String CMD_TCB_CPUTIME_BEFORE = "CMD_TCB_CPUTIME_BEFORE";
    public static final String CMD_TCB_CPUTIME_AFTER = "CMD_TCB_CPUTIME_AFTER";
    public static final String CMD_TCB_CPUTIME = "CMD_TCB_CPUTIME";
    public static final String CMD_OD_ADPTRD1 = "CMD_OD_ADPTRD1";
    public static final String CMD_OD_ADPTRD2 = "CMD_OD_ADPTRD2";
    public static final String CMD_OD_ADPTRD3 = "CMD_OD_ADPTRD3";
    public static final String CMD_OD_ADPTRID = "CMD_OD_ADPTRID";
    public static final String CMD_OD_APPLID = "CMD_OD_APPLID";
    public static final String CMD_OD_CLNTIPAD = "CMD_OD_CLNTIPAD";
    public static final String CMD_OD_CLNTPORT = "CMD_OD_CLNTPORT";
    public static final String CMD_OD_FACILNM = "CMD_OD_FACILNM";
    public static final String CMD_OD_FACILTYPE = "CMD_OD_FACILTYPE";
    public static final String CMD_OD_IPFAMILY = "CMD_OD_IPFAMILY";
    public static final String CMD_OD_LUNAME = "CMD_OD_LUNAME";
    public static final String CMD_OD_NETID = "CMD_OD_NETID";
    public static final String CMD_OD_NETWORKID = "CMD_OD_NETWORKID";
    public static final String CMD_OD_STARTTIM = "CMD_OD_STARTTIM";
    public static final String CMD_OD_TASKID = "CMD_OD_TASKID";
    public static final String CMD_OD_TRANSID = "CMD_OD_TRANSID";
    public static final String CMD_OD_USERID = "CMD_OD_USERID";
    public static final String CMD_PH_APPLID = "CMD_PH_APPLID";
    public static final String CMD_PH_COUNT = "CMD_PH_COUNT";
    public static final String CMD_PH_NETWORKID = "CMD_PH_NETWORKID";
    public static final String CMD_PH_STARTTIM = "CMD_PH_STARTTIM";
    public static final String CMD_PH_TASKID = "CMD_PH_TASKID";
    public static final String CMD_PH_TRANSID = "CMD_PH_TRANSID";
    public static final String CMD_STARTTIM = "CMD_STARTTIM";
    public static final String TCB_SWTICHING_SPECIFIC = "tcbSwitchingSpecific";
    public static final String SYS_ID_SPECIFIC = "sysIdSpecific";
    public static final String CMD_RMTNAME = "CMD_RMTNAME";
    public static final String CMD_RMTSYSID = "CMD_RMTSYSID";
    private static final String[] ia31SpecificAttributes = new String[]{"CMDFLOW_ID", "APPLID", "SYSID", "TRANSID", "TASKID", "DISTRIBUTED_UOW", "CICS_UOW", "USERID", "CONCURRENCY", "API", "PROGRAM", "OFFSET", "FUNCTION_TYPE", "FUNCTION_ID", "FUNCTION", "TYPE", "RESOURCE_NAME", "TCBMODE", "PREV_TCBMODE", "BEFORE_MODESWITCH", "AFTER_MODESWITCH", "CICS_VERSION", "CMD_TIME_LOCAL", "CMD_EIBRESP", "CMD_EIBRESP2", "CMD_EIDARG0_DATA"};
    private static final String[] ia32SpecificAttributes = new String[]{"TRACE_ID", "CMD_USER_DAT1", "CMD_USER_DAT2", "CMD_USER_DAT3"};
    private static final String[] ia51SpecificAttributes = new String[]{"APP_NAME", "APP_VER1", "APP_VER2", "APP_VER3", "APP_OPER", "CMD_TCB_CPUTIME_BEFORE", "CMD_TCB_CPUTIME_AFTER"};
    private static final String[] ia52SpecificAttributes = new String[]{"CMD_OD_ADPTRD1", "CMD_OD_ADPTRD2", "CMD_OD_ADPTRD3", "CMD_OD_ADPTRID", "CMD_OD_APPLID", "CMD_OD_CLNTIPAD", "CMD_OD_CLNTPORT", "CMD_OD_FACILNM", "CMD_OD_FACILTYPE", "CMD_OD_IPFAMILY", "CMD_OD_LUNAME", "CMD_OD_NETID", "CMD_OD_NETWORKID", "CMD_OD_STARTTIM", "CMD_OD_TASKID", "CMD_OD_TRANSID", "CMD_OD_USERID", "CMD_PH_APPLID", "CMD_PH_COUNT", "CMD_PH_NETWORKID", "CMD_PH_STARTTIM", "CMD_PH_TASKID", "CMD_PH_TRANSID", "CMD_STARTTIM", "PLATFORM"};
    private static final String[] tcbSwitchingSpecificAttributes = new String[]{"TCB_SWITCH_BEFORE_COUNT", "TCB_SWITCH_AFTER_COUNT"};
    private static final String[] sysIdSpecificAttributes = new String[]{"CMD_RMTNAME", "CMD_RMTSYSID"};
    private static String[] supersetAttributes;

    @Override
    public String[] getSupersetAttributes() {
        Debug.enter((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"getSupersetAttributes", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (supersetAttributes == null) {
            supersetAttributes = IAUtilities.concat(ia31SpecificAttributes, ia32SpecificAttributes, tcbSwitchingSpecificAttributes, ia51SpecificAttributes, ia52SpecificAttributes, sysIdSpecificAttributes);
        }
        Debug.exit((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"getSupersetAttributes", (Object)("result length: " + supersetAttributes.length));
        return supersetAttributes;
    }

    @Override
    public void adjustToCurrentVersion() {
        Debug.enter((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"adjustToCurrentVersion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        FindTableAttributesCommand command = new FindTableAttributesCommand(IAUtilities.getCommandFlowTableName());
        command.setAsync(false);
        command.start();
        String[] liveColumns = command.getColumnNames();
        this.attributes = this.adjustLiveColumns(liveColumns);
        Debug.exit((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"adjustToCurrentVersion");
    }

    public String[] adjustLiveColumns(String[] columns) {
        Debug.enter((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"adjustLiveColumns", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "columns length: " + columns.length});
        ArrayList<String> adjustedColumns = new ArrayList<String>();
        List<String> knownAttributes = Arrays.asList(this.getSupersetAttributes());
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (knownAttributes.contains(attribute)) {
                adjustedColumns.add(attribute);
            }
            ++n2;
        }
        String[] result = adjustedColumns.toArray(new String[0]);
        Debug.exit((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"adjustLiveColumns", (Object)("result length: " + result.length));
        return result;
    }

    @Override
    public Map<String, String> checkCompatibility(List<String> attributesToCheck) {
        Debug.enter((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"checkCompatibility", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "attributesToCheck size: " + attributesToCheck.size()});
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> incompatibleAttributes = new ArrayList<String>();
        List<String> currentAttributesList = Arrays.asList(this.attributes);
        for (String attribute : attributesToCheck) {
            if (currentAttributesList.contains(attribute)) continue;
            incompatibleAttributes.add(attribute);
        }
        List<String> ia52SpecificList = Arrays.asList(ia52SpecificAttributes);
        List<String> ia51SpecificList = Arrays.asList(ia51SpecificAttributes);
        List<String> ia32SpecificList = Arrays.asList(ia32SpecificAttributes);
        List<String> ia31SpecificList = Arrays.asList(ia31SpecificAttributes);
        List<String> tcbSwitchingSpecificList = Arrays.asList(tcbSwitchingSpecificAttributes);
        List<String> sysIdSpecificList = Arrays.asList(sysIdSpecificAttributes);
        for (String attribute : incompatibleAttributes) {
            boolean knownVersion = false;
            if (ia52SpecificList.contains(attribute)) {
                result.put(attribute, "ia52Specific");
                knownVersion = true;
            } else if (ia51SpecificList.contains(attribute)) {
                result.put(attribute, "ia51Specific");
                knownVersion = true;
            } else if (ia32SpecificList.contains(attribute)) {
                result.put(attribute, "ia32Specific");
                knownVersion = true;
            } else if (ia31SpecificList.contains(attribute)) {
                result.put(attribute, "ia31Specific");
                knownVersion = true;
            } else if (tcbSwitchingSpecificList.contains(attribute)) {
                result.put(attribute, TCB_SWTICHING_SPECIFIC);
                knownVersion = true;
            } else if (sysIdSpecificList.contains(attribute)) {
                result.put(attribute, SYS_ID_SPECIFIC);
                knownVersion = true;
            }
            if (knownVersion) continue;
            result.put(attribute, "unknown");
        }
        Debug.exit((Logger)logger, (String)CommandFlowAttributes.class.getName(), (String)"checkCompatibility", (Object)("result size: " + result.size()));
        return result;
    }
}

