/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.List;
import java.util.logging.Logger;

public class ApplicationSubQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ApplicationSubQuery.class.getPackage().getName());
    private Presentation presentation;

    public ApplicationSubQuery(String typeValue, List<String> rootExpression, boolean is) {
        String[] columns;
        Debug.enter((Logger)logger, (String)ApplicationSubQuery.class.getName(), (String)"ApplicationSubQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getApplicationResourcesTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        String[] stringArray = columns = this.getDefaultColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            selection.getSelect().addSelectionColumn(column, table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            ++n2;
        }
        selection.getSelect().setDistinct(true);
        selection.appendCondition("APPLIC_TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{typeValue}, QueryElement.Predicate.AND, false);
        Object[] values = rootExpression.toArray();
        if (values.length == 1) {
            selection.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.LI, values, QueryElement.Predicate.AND, !is);
        } else {
            Object[] objectArray = values;
            int n3 = values.length;
            n = 0;
            while (n < n3) {
                Object value = objectArray[n];
                selection.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.LI, new Object[]{value}, QueryElement.Predicate.AND, !is);
                ++n;
            }
        }
        this.presentation = PresentationFactory.getInstance().createPresentation("", "", "", selection);
        Debug.enter((Logger)logger, (String)ApplicationSubQuery.class.getName(), (String)"ApplicationSubQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public ApplicationSubQuery(String typeValue, String rootExpression) {
        String[] columns;
        Debug.enter((Logger)logger, (String)ApplicationSubQuery.class.getName(), (String)"ApplicationSubQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getApplicationResourcesTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        String[] stringArray = columns = this.getDefaultColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            selection.getSelect().addSelectionColumn(column, table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            ++n2;
        }
        selection.getSelect().setDistinct(true);
        if (typeValue.length() > 0) {
            selection.appendCondition("APPLIC_TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{typeValue}, QueryElement.Predicate.AND, false);
        }
        if (IAUtilities.hasContent(rootExpression)) {
            if (IAUtilities.isExactName(rootExpression)) {
                selection.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{rootExpression}, QueryElement.Predicate.AND, false);
            } else {
                selection.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.LI, new Object[]{rootExpression}, QueryElement.Predicate.AND, false);
            }
        }
        this.presentation = PresentationFactory.getInstance().createPresentation(String.valueOf(rootExpression) + "-" + typeValue, null, null, selection);
        Debug.exit((Logger)logger, (String)ApplicationSubQuery.class.getName(), (String)"ApplicationSubQuery");
    }

    protected String[] getDefaultColumns() {
        return new String[]{"APPLIC_RESNAME"};
    }

    public Presentation getPresentation() {
        return this.presentation;
    }
}

