/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.viz;

import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.NodeConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Node<T>
implements INode<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected INestedNode parent;
    protected T object;
    protected ArrayList<NodeConnection> incomingConnections = new ArrayList();
    protected ArrayList<NodeConnection> outgoingConnections = new ArrayList();
    private ArrayList<IModelChangeListener> listeners = new ArrayList();
    private HashMap data = new HashMap();

    @Override
    public INestedNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(INestedNode resourceNode) {
        this.parent = resourceNode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    @Override
    public int compareTo(INode that) {
        int parentsComparison;
        if (this == that) {
            return 0;
        }
        if (this.equals(that)) {
            return 0;
        }
        if (this.parent != null && (parentsComparison = this.parent.compareTo(that.getParent())) != 0) {
            return parentsComparison;
        }
        if (this.object != null && this.object instanceof Comparable) {
            if (that.getObject() == null) {
                return 1;
            }
            if (that.getObject() instanceof Comparable) {
                return ((Comparable)this.object).compareTo(that.getObject());
            }
        }
        return 0;
    }

    public String toString() {
        return "Node : {" + this.object.toString() + "}";
    }

    @Override
    public List<NodeConnection> getIncomingConnections() {
        return this.incomingConnections;
    }

    @Override
    public List<NodeConnection> getOutgoingConnections() {
        return this.outgoingConnections;
    }

    @Override
    public void addModelChangeListener(IModelChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelChangeListener(IModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireModelChanged() {
        for (IModelChangeListener listener : this.listeners) {
            listener.onModelChanged(this);
        }
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T anObject) {
        this.object = anObject;
    }

    @Override
    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public void setData(Object value) {
        this.data.put(null, value);
    }

    @Override
    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public Object getData() {
        return this.data.get(null);
    }
}

