/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class WebservicePropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(WebservicePropertySource.class.getPackage().getName());
    public static final String APPLID = "APPLID";
    public static final String BINDING = "BINDING";
    public static final String CCSID = "CCSID";
    public static final String CONTAINER = "CONTAINER";
    public static final String ENDPOINT = "ENDPOINT";
    public static final String FIRST_RUN = "FIRST_RUN";
    public static final String HOMESYSID = "HOMESYSID";
    public static final String LAST_MODIFIED = "LAST_MODIFIED";
    public static final String LAST_RUN = "LAST_RUN";
    public static final String MAPPINGLEVEL = "MAPPINGLEVEL";
    public static final String MAPPINGNUM = "MAPPINGRNUM";
    public static final String MAPPINGVNUM = "MAPPINGVNUM";
    public static final String MINRUNLEVEL = "MINRUNLEVEL";
    public static final String MINRUNNUM = "MINRUNRNUM";
    public static final String MINRUNVNUM = "MINRUNVNUM";
    public static final String NAME = "NAME";
    public static final String PIPELINE = "PIPELINE";
    public static final String PGMINTERFACE = "PGMINTERFACE";
    public static final String PROGRAM = "PROGRAM";
    public static final String URIMAP = "URIMAP";
    public static final String VALIDATIONSTATUS = "VALIDATIONSTATUS";
    public static final String WSBIND_FILENAME = "WSBIND_FILENAME";
    public static final String WSDL_FILENAME = "WSDL_FILENAME";
    public static final String XOPDIRECTST = "XOPDIRECTST";
    public static final String XOPSUPPORTST = "XOPSUPPORTST";
    public static final String COLLECTION_ID = "COLLECTION_ID";
    public static final String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static String APPL_NAME = "APPL_NAME";
    private static String APPL_VER1 = "APPL_VER1";
    private static String APPL_VER2 = "APPL_VER2";
    private static String APPL_VER3 = "APPL_VER3";
    private static String APPL_OPER = "APPL_OPER";
    private static String PLATFORM = "PLATFORM";
    private static final String[] ia31propertyIDs = new String[]{"APPLID", "HOMESYSID", "NAME", "PROGRAM", "URIMAP", "CCSID", "CONTAINER", "MAPPINGLEVEL", "MAPPINGRNUM", "MAPPINGVNUM", "MINRUNLEVEL", "MINRUNVNUM", "PIPELINE", "PGMINTERFACE", "VALIDATIONSTATUS", "XOPDIRECTST", "XOPSUPPORTST", "WSDL_FILENAME", "WSBIND_FILENAME", "ENDPOINT", "BINDING", "LAST_MODIFIED", "FIRST_RUN", "LAST_RUN"};
    private static final String[] ia32propertyIDs = IAUtilities.concat(ia31propertyIDs, new String[][]{{"COLLECTION_ID", "ARCHIVE_DATE"}});
    private static final String[] ia51propertyIDs = IAUtilities.concat(ia32propertyIDs, new String[][]{{APPL_NAME, APPL_VER1, APPL_VER2, APPL_VER3, APPL_OPER}});
    private static final String[] ia52propertyIDs = IAUtilities.concat(ia51propertyIDs, new String[][]{{PLATFORM}});

    public WebservicePropertySource(Resource resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null && !this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            List properties = this.resource.getProperties();
            this.processProperties(properties);
        }
        return this.getPropertiesInCurrentCollectionId();
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)WebservicePropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] propertyIDs = WebservicePropertySource.getPropertyIDs();
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map propsInCurrentRegion = (Map)properties.get(i);
            ArrayList<PropertyDescriptor> descriptors = (ArrayList<PropertyDescriptor>)this.collectionID2Props.get((String)propsInCurrentRegion.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<PropertyDescriptor>();
                this.collectionID2Props.put((String)propsInCurrentRegion.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: {
                    categoryName = MessageFormat.format(Messages.getString("WebServicePropertySource.3200"), (String)propsInCurrentRegion.get(NAME), (String)propsInCurrentRegion.get(COLLECTION_ID), (String)propsInCurrentRegion.get(APPLID));
                    break;
                }
                case 5100: 
                case 5110: {
                    String ver1 = (String)propsInCurrentRegion.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)propsInCurrentRegion.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)propsInCurrentRegion.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(null, (String)propsInCurrentRegion.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("WebServicePropertySource.3200"), (String)propsInCurrentRegion.get(NAME), (String)propsInCurrentRegion.get(COLLECTION_ID), (String)propsInCurrentRegion.get(APPLID))) + ", " + app1.getFullName() + " (" + propsInCurrentRegion.get(APPL_OPER) + ")";
                    break;
                }
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    String ver1 = (String)propsInCurrentRegion.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)propsInCurrentRegion.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)propsInCurrentRegion.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(new Platform((String)propsInCurrentRegion.get(PLATFORM)), (String)propsInCurrentRegion.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("WebServicePropertySource.3200"), (String)propsInCurrentRegion.get(NAME), (String)propsInCurrentRegion.get(COLLECTION_ID), (String)propsInCurrentRegion.get(APPLID))) + ", " + propsInCurrentRegion.get(PLATFORM) + ", " + app1.getFullName() + " (" + propsInCurrentRegion.get(APPL_OPER) + ")";
                    break;
                }
                case 3100: {
                    categoryName = MessageFormat.format(Messages.getString("WebServicePropertySource.3100"), (String)propsInCurrentRegion.get(NAME), (String)propsInCurrentRegion.get(APPLID));
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("WebServicePropertySource.3100"), (String)propsInCurrentRegion.get(NAME), (String)propsInCurrentRegion.get(APPLID));
                }
            }
            int j = 0;
            while (j < propertyIDs.length) {
                String commonKey = propertyIDs[j];
                String regionKey = String.valueOf(commonKey) + propsInCurrentRegion.get(COLLECTION_ID) + (String)propsInCurrentRegion.get(APPLID) + "_" + Integer.toString(i);
                this.values.put(regionKey, propsInCurrentRegion.get(commonKey));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)regionKey, Messages.getString(commonKey));
                descriptor.setCategory(categoryName);
                descriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)WebservicePropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return WebservicePropertySource.getPropertyIDs().length;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3100: {
                return ia31propertyIDs;
            }
            case 3200: {
                return ia32propertyIDs;
            }
            case 5100: 
            case 5110: {
                return ia51propertyIDs;
            }
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia52propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

