/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.HashSet;

public class Verb {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Resource source;
    private final Resource target;
    private final String name;
    private final String remoteName;
    private final String remoteSysid;
    private static HashSet<String> eventableVerbs = new HashSet();

    static {
        eventableVerbs.add("WRITE OPERATOR");
    }

    public Verb(Resource source, String name, Resource target) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.remoteName = null;
        this.remoteSysid = null;
    }

    public Verb(Resource source, String name, Resource target, String remoteSysid, String remoteName) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.remoteName = !IAUtilities.isDashed(remoteName) ? remoteName : null;
        this.remoteSysid = !IAUtilities.isDashed(remoteSysid) ? remoteSysid : null;
    }

    public String toString() {
        return this.source + " > " + this.name + " < " + this.target;
    }

    public boolean equals(Object aVerb) {
        if (!(aVerb instanceof Verb)) {
            return false;
        }
        Verb verb = (Verb)aVerb;
        boolean result = true;
        result &= this.name.equals(verb.name);
        result &= this.source.equals(verb.source);
        result &= this.target.equals(verb.target);
        result &= this.remoteName != null ? this.remoteName.equals(verb.remoteName) : this.remoteName == verb.remoteName;
        return result &= this.remoteSysid != null ? this.remoteSysid.equals(verb.remoteSysid) : this.remoteSysid == verb.remoteSysid;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.name.hashCode();
        result = result * prime + this.source.hashCode();
        result = result * prime + this.target.hashCode();
        result = this.remoteName != null ? result * prime + this.remoteName.hashCode() : result;
        result = this.remoteSysid != null ? result * prime + this.remoteSysid.hashCode() : result;
        return result;
    }

    public Resource getSource() {
        return this.source;
    }

    public Resource getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getRemoteSysid() {
        return this.remoteSysid;
    }

    public boolean isEventable() {
        return eventableVerbs.contains(this.name);
    }
}

