/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.model.ExecutionAnalyzer;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.runtime.IAPlugin;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class TaskExecutionAnalyzer
extends ExecutionAnalyzer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TaskExecutionAnalyzer.class.getPackage().getName());
    private Task task;
    private CommandListener commandListener = new CommandListener();

    public SQLCommand getCommand() {
        return this.task.getCommand();
    }

    public TaskExecutionAnalyzer(Task task) {
        Debug.enter((Logger)logger, (String)TaskExecutionAnalyzer.class.getName(), (String)"TaskExecutionAnalyzer", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "task: " + (task == null ? task : task.getName())});
        this.task = task;
        if (task.getRegions().size() == 1) {
            this.region = (Region)task.getRegions().get(0);
        }
        this.getCommand().addListener((EngineShell.EngineListener)this.commandListener);
        Debug.exit((Logger)logger, (String)TaskExecutionAnalyzer.class.getName(), (String)"TaskExecutionAnalyzer");
    }

    @Override
    public void start() {
        Debug.enter((Logger)logger, (String)TaskExecutionAnalyzer.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IAPlugin.getDefault().isCommandLoggingActive()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.task.toString());
            IAPlugin.getDefault().logInformation(">Task : " + buffer.toString());
        }
        if (this.status == 1) {
            Debug.exit((Logger)logger, (String)TaskExecutionAnalyzer.class.getName(), (String)"start", (Object)"status == COMPLETE");
            return;
        }
        this.status = 0;
        if (this.task.getCommand().status() == 1) {
            for (Object o : this.listeners) {
                ((ExecutionAnalyzer.Listener)o).itemsAdded(this.task.getCommands());
            }
            for (Object o : this.listeners) {
                ((ExecutionAnalyzer.Listener)o).completed();
            }
            IAPlugin.getDefault().taskEnded();
        } else {
            if (this.getCommand().status() == 3) {
                this.commandListener.notifyAboutAllData();
                Debug.exit((Logger)logger, (String)TaskExecutionAnalyzer.class.getName(), (String)"start", (Object)"getCommand().status() == Command.PAUSED");
                return;
            }
            this.task.getCommands();
        }
        Debug.exit((Logger)logger, (String)TaskExecutionAnalyzer.class.getName(), (String)"start");
    }

    @Override
    public Resource getRoot() {
        return this.task.getTransaction();
    }

    @Override
    public String[] getColumns() {
        return this.task.getCommandColumns();
    }

    public List getResults() {
        return this.totalInteractions;
    }

    private class CommandListener
    implements EngineShell.EngineListener {
        private CommandListener() {
        }

        public void notifyAboutAllData() {
            Debug.enter((Logger)logger, (String)CommandListener.class.getName(), (String)"notifyAboutAllData", (Object)("Thread ID: " + Thread.currentThread().getId()));
            this.statusUpdate(EngineShell.EngineStatus.Paused);
            Debug.exit((Logger)logger, (String)CommandListener.class.getName(), (String)"notifyAboutAllData");
        }

        public void statusUpdate(EngineShell.EngineStatus es) {
            Debug.enter((Logger)logger, (String)CommandListener.class.getName(), (String)"statusUpdate", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "engine status: " + es});
            switch (es) {
                case Complete: {
                    TaskExecutionAnalyzer.this.status = 1;
                    for (Object o : TaskExecutionAnalyzer.this.listeners) {
                        ((ExecutionAnalyzer.Listener)o).itemsAdded(TaskExecutionAnalyzer.this.totalInteractions);
                    }
                    this.notifyOnCompletion();
                    IAPlugin.getDefault().taskEnded();
                    break;
                }
                case Paused: {
                    TaskExecutionAnalyzer.this.status = 3;
                    for (Object o : TaskExecutionAnalyzer.this.listeners) {
                        ((ExecutionAnalyzer.Listener)o).itemsAdded(TaskExecutionAnalyzer.this.totalInteractions);
                    }
                    break;
                }
                case Error: {
                    TaskExecutionAnalyzer.this.status = 2;
                    this.notifyOnCompletion();
                    break;
                }
                case Cancelled: {
                    TaskExecutionAnalyzer.this.status = 4;
                    this.notifyOnCompletion();
                }
            }
            Debug.exit((Logger)logger, (String)CommandListener.class.getName(), (String)"statusUpdate", (Object)("status == " + TaskExecutionAnalyzer.this.status));
        }

        public void notifyResultCount(int count) {
        }

        public void dataAvailable(Collection<Object> items) {
            TaskExecutionAnalyzer.this.totalInteractions.addAll(items);
        }

        private void notifyOnCompletion() {
            Debug.enter((Logger)logger, (String)CommandListener.class.getName(), (String)"notifyOnCompletion", (Object)("Thread ID: " + Thread.currentThread().getId()));
            List copyOfListeners = (List)TaskExecutionAnalyzer.this.listeners.clone();
            for (ExecutionAnalyzer.Listener o : copyOfListeners) {
                o.completed();
            }
            Debug.exit((Logger)logger, (String)CommandListener.class.getName(), (String)"notifyOnCompletion");
        }
    }
}

