/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.CommandExecutionForTaskCommand;
import com.ibm.cics.ia.commands.RegionsForTaskCommand;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class Task
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Task.class.getPackage().getName());
    private String applId;
    private String distributedUOW;
    private String traceId;
    private final Transaction transaction;
    private Timestamp commandTime;
    private final String taskID;
    private List commands;
    private StringBuffer buffer;
    private List sourceTransactionInteractions;
    private List sourceProgramInteractions;
    private CommandExecutionForTaskCommand command = new CommandExecutionForTaskCommand(this);

    public Task(Transaction transaction, String taskID, String distributedUOW, Timestamp commandTime, String traceId, String applId) {
        this(transaction, taskID, distributedUOW, commandTime);
        this.traceId = traceId;
        this.applId = applId;
    }

    public Task(Transaction transaction, String taskID, String distributedUOW, Timestamp commandTime) {
        super("TASKID", taskID);
        this.taskID = taskID;
        this.transaction = transaction;
        this.distributedUOW = distributedUOW;
        this.commandTime = commandTime;
    }

    public Task(String taskID, Transaction transaction, String applId) {
        super("TASKID", taskID);
        this.transaction = transaction;
        this.taskID = taskID;
        this.applId = applId;
    }

    public String getApplId() {
        return this.applId;
    }

    public String getDistributedUOW() {
        return this.distributedUOW;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public Timestamp getCommandTime() {
        return this.commandTime;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public SQLCommand getCommand() {
        return this.command;
    }

    public List getCommands() {
        Debug.enter((Logger)logger, (String)Task.class.getName(), (String)"getCommands", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.commands == null) {
            this.command.start();
            if (this.command.status() != 2) {
                this.commands = this.command.getResults();
            }
        }
        Debug.exit((Logger)logger, (String)Task.class.getName(), (String)"getCommands", (Object)("result size: " + this.commands.size()));
        return this.commands;
    }

    @Override
    public String toString() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
            this.buffer.append("TASKID").append(" (").append(this.taskID).append(")");
        }
        return this.buffer.toString();
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForTaskCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return null;
    }

    @Override
    public List getProperties() {
        return null;
    }

    @Override
    public List getSourceInteractions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getSourceProgramInteractions() {
        Debug.enter((Logger)logger, (String)Task.class.getName(), (String)"getSourceProgramInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceProgramInteractions == null) {
            this.sourceProgramInteractions = this.transaction.getSourceProgramInteractions();
        }
        Debug.exit((Logger)logger, (String)Task.class.getName(), (String)"getSourceProgramInteractions", (Object)("result size: " + this.sourceProgramInteractions.size()));
        return this.sourceProgramInteractions;
    }

    @Override
    public List getSourceTransactionInteractions() {
        Debug.enter((Logger)logger, (String)Task.class.getName(), (String)"getSourceTransactionInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceTransactionInteractions == null) {
            this.sourceTransactionInteractions = this.transaction.getSourceTransactionInteractions();
        }
        Debug.exit((Logger)logger, (String)Task.class.getName(), (String)"getSourceTransactionInteractions", (Object)("result size: " + this.sourceTransactionInteractions.size()));
        return this.sourceTransactionInteractions;
    }

    public String[] getCommandColumns() {
        return CommandExecutionForTaskCommand.getColumns();
    }

    public String getTraceId() {
        return this.traceId;
    }
}

