/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.CICSResource;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import java.util.ArrayList;
import java.util.logging.Logger;

public class TSApplication
extends CICSResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TSApplication.class.getPackage().getName());
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int microVersion = 0;
    private ArrayList<Operation> operations = new ArrayList();
    private Platform platform;

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public TSApplication(String resourceName) {
        super("TS_APPLICATION", resourceName);
    }

    public TSApplication(Platform platform, String resourceName, int majorVersion, int minorVersion, int microVersion) {
        this(resourceName);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
        this.platform = platform;
    }

    public String getFullName() {
        return String.valueOf(this.getName().trim()) + " (" + Integer.toString(this.majorVersion) + "." + Integer.toString(this.minorVersion) + "." + Integer.toString(this.microVersion) + ")";
    }

    public static String getFullName(String name, int majorVersion, int minorVersion, int microVersion) {
        return String.valueOf(name.trim()) + " " + Integer.toString(majorVersion) + "." + Integer.toString(minorVersion) + "." + Integer.toString(microVersion) + ")";
    }

    public void setVersions(int majorVersion, int minorVersion, int microVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
    }

    public String getVersionText() {
        return String.valueOf(Integer.toString(this.majorVersion)) + "." + Integer.toString(this.minorVersion) + "." + Integer.toString(this.microVersion);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public void addOperation(Operation operation) {
        Debug.enter((Logger)logger, (String)TSApplication.class.getName(), (String)"addOperation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.operations.contains(operation)) {
            this.operations.add(operation);
        }
        Debug.exit((Logger)logger, (String)TSApplication.class.getName(), (String)"addOperation");
    }

    public void removeOperation(Operation operation) {
        this.operations.remove(operation);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result) {
            return false;
        }
        if (!(obj instanceof TSApplication)) {
            return false;
        }
        TSApplication appl = (TSApplication)obj;
        return this.getFullName().equals(appl.getFullName());
    }

    @Override
    public int hashCode() {
        int shift = 31;
        int superHash = super.hashCode();
        return superHash * shift + this.getFullName().hashCode();
    }

    public ArrayList<Operation> getOperations() {
        return (ArrayList)this.operations.clone();
    }
}

