/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.FindEventsCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Event;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.runtime.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;

public abstract class Resource
implements IAdaptable,
IActionFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Resource.class.getPackage().getName());
    public static final String LINK = "LINK";
    public static final String CALL = "CALL";
    public static final String LOAD = "LOAD";
    public static final String XCTL = "XCTL";
    public static final String START = "START";
    public static final String STARTREQ = "START REQID";
    public static final String RETURN = "RETURN";
    public static final String INIT = "INIT";
    public static final Object READ_UPD = "READ UPD";
    public static final String READQ = "READQ";
    public static final String WRITEQ = "WRITEQ";
    public static final String DELETEQ = "DELETEQ";
    public static final String ATOMSERVICE_TYPE = "ATOMSERVICE";
    public static final String DB2ENTRY_TYPE = "DB2ENTRY";
    public static final String FILE_TYPE = "FILE";
    public static final String TRANSACTION_TYPE = "TRANSID";
    public static final String TASK_TYPE = "TASKID";
    public static final String TDQ_TYPE = "TD";
    public static final String MAP_TYPE = "MAP";
    public static final String PROGRAM_TYPE = "PROGRAM";
    public static final String TS_TYPE = "TSQUEUE";
    public static final String TD_TYPE = "TDQUEUE";
    public static final String CURSOR_TYPE = "CURSOR";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VIEW_TYPE = "VIEW";
    public static final String STATEMENT_TYPE = "STATEMENT";
    public static final String QUEUE_TYPE = "QUEUE";
    public static final String PCB_TYPE = "PCB";
    public static final String PSB_TYPE = "PSB";
    public static final String TSSHR_TYPE = "TSQUEUE SHARED";
    public static final String TSAUX_TYPE = "TSQUEUE AUX";
    public static final String EXIT_TYPE = "EXIT";
    public static final String REGION_TYPE = "APPLID";
    public static final String DB2_ENTRY_TYPE = "DB2ENTRY";
    public static final String DB2_TRANSACTION_TYPE = "DB2TRAN";
    public static final String DOCUMENT_TEMPATE_TYPE = "DOCTEMP";
    public static final String IPCONN_TYPE = "IPCONN";
    public static final String JVM_PROFILE_TYPE = "JVMPROFILE";
    public static final String PIPELINE_TYPE = "PIPELINE";
    public static final String PROCESS_TYPE = "PROCESS";
    public static final String TCPIP_SERVICE_TYPE = "TCPIPSERVICE";
    public static final String TS_MODEL_TYPE = "TSMODEL";
    public static final String UOW_TYPE = "UOW";
    public static final String URIMAP_TYPE = "URIMAP";
    public static final String WEBSERVICE_TYPE = "WEBSERVICE";
    public static final String SERVICE_TYPE = "SERVICE";
    public static final String MAPSET_TYPE = "MAPSET";
    public static final String CHANNEL_TYPE = "CHANNEL";
    public static final String CONTAINER_TYPE = "CONTAINER";
    public static final String EVENT_TYPE = "EVENT";
    public static final String IA_APPLICATION_TYPE = "IA_APPLICATION";
    public static final String TS_APPLICATION_TYPE = "TS_APPLICATION";
    public static final String OPERATION_TYPE = "OPERATION";
    public static final String PLATFORM_TYPE = "PLATFORM";
    public static final String DB_VERSION_GREATER_OR_EQUALS = "DB_VERSION_GREATER_OR_EQUALS";
    protected ResourcePropertySource propertySource;
    private transient Map adapters;
    protected List sourceInteractions;
    protected List sourceProgramInteractions;
    protected List sourceTransactionInteractions;
    protected HashMap<String, List> regions;
    protected HashMap<String, List> platforms;
    protected final String typeName;
    protected final String name;
    private Map verbNamesAndSources;
    private Map<String, List<Event>> verbToEvents;
    private static final Map<String, String> iaToEpResourcesMap = Resource.createIaToEpResourcesMap();

    private static Map<String, String> createIaToEpResourcesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(CHANNEL_TYPE, CHANNEL_TYPE);
        result.put(CONTAINER_TYPE, CONTAINER_TYPE);
        result.put(EVENT_TYPE, EVENT_TYPE);
        result.put(FILE_TYPE, FILE_TYPE);
        result.put(MAP_TYPE, MAP_TYPE);
        result.put(MAPSET_TYPE, MAPSET_TYPE);
        result.put(PROGRAM_TYPE, PROGRAM_TYPE);
        result.put(TS_TYPE, "QNAME");
        result.put(TD_TYPE, QUEUE_TYPE);
        result.put(SERVICE_TYPE, SERVICE_TYPE);
        result.put(TRANSACTION_TYPE, TRANSACTION_TYPE);
        result.put(URIMAP_TYPE, URIMAP_TYPE);
        return result;
    }

    public List getRegions() {
        String collectionId;
        List result;
        Debug.enter((Logger)logger, (String)Resource.class.getName(), (String)"getRegions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.regions == null) {
            this.regions = new HashMap();
        }
        if ((result = this.regions.get(collectionId = IASQLCommand.getCollectionId())) == null) {
            Command getRegionsCommand = this.createGetRegionsCommand();
            getRegionsCommand.start();
            result = getRegionsCommand.getResults();
            this.regions.put(collectionId, result);
        }
        Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"getRegions", (Object)("result size: " + result.size()));
        return result;
    }

    public List getPlatforms() {
        String collectionId;
        List result;
        Debug.enter((Logger)logger, (String)Resource.class.getName(), (String)"getPlatforms", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.platforms == null) {
            this.platforms = new HashMap();
        }
        if ((result = this.platforms.get(collectionId = IASQLCommand.getCollectionId())) == null) {
            Command getPlatformsCommand = this.createGetPlatformsCommand();
            if (getPlatformsCommand != null) {
                getPlatformsCommand.start();
                result = getPlatformsCommand.getResults();
                this.platforms.put(collectionId, result);
            } else {
                result = new ArrayList();
                this.platforms.put(collectionId, result);
            }
        }
        Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"getPlatforms", (Object)("result size: " + result.size()));
        return result;
    }

    public Resource(String typeName, String name) {
        this.name = name;
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        int shift = 31;
        return this.typeName.hashCode() * shift + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == null ? false : obj.getClass().equals(this.getClass()) && ((Resource)obj).getTypeName().equals(this.getTypeName()) && ((Resource)obj).getName().equals(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getTypeName()) + " (" + this.getName() + ")";
    }

    public void registerAdapter(Object adapter) {
        if (this.adapters == null) {
            this.adapters = new IdentityHashMap();
        }
        this.adapters.put(adapter.getClass(), adapter);
    }

    public Object getAdapter(Class adapterType) {
        return this.adapters == null ? null : this.adapters.get(adapterType);
    }

    public List getSourcesForVerbAndType(String verbName, String resourceType) {
        List result = (List)this.getSourcesForVerb(verbName).get(resourceType);
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public Map getSourcesForVerb(String verbName) {
        Debug.enter((Logger)logger, (String)Resource.class.getName(), (String)"getSourcesForVerb", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verbName: " + verbName});
        this.getSourceInteractions();
        if (this.verbNamesAndSources == null) {
            this.verbNamesAndSources = Interaction.getTypesAndTargetsByVerb(this.sourceInteractions);
        }
        Map result = (Map)this.verbNamesAndSources.get(verbName);
        Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"getSourcesForVerb", (Object)(result == null ? "Collections.EMPTY_MAP" : "result size: " + result.size()));
        return result == null ? Collections.EMPTY_MAP : result;
    }

    public boolean isEventable() {
        return iaToEpResourcesMap.containsKey(this.getTypeName());
    }

    public String getEpType() {
        return iaToEpResourcesMap.get(this.getTypeName());
    }

    public List<Event> getEvents(String verb) {
        Debug.enter((Logger)logger, (String)Resource.class.getName(), (String)"getEvents", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verb" + verb});
        if (this.verbToEvents == null) {
            this.verbToEvents = new HashMap<String, List<Event>>();
            if (Version.getInstance().getDBVersion() >= 3200) {
                List events = IASQLCommand.runCommandSynch(new FindEventsCommand(this));
                for (Object event : events) {
                    String[] values = (String[])event;
                    if (!this.verbToEvents.containsKey(values[3])) {
                        this.verbToEvents.put(values[3], new ArrayList());
                    }
                    this.verbToEvents.get(values[3]).add(new Event(values[0], values[1], values[2]));
                }
            }
        }
        Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"getEvents", (Object)("result size: " + (this.verbToEvents.get(verb) == null ? this.verbToEvents : Integer.valueOf(this.verbToEvents.get(verb).size()))));
        return this.verbToEvents.get(verb);
    }

    public boolean testAttribute(Object target, String name, String value) {
        Debug.enter((Logger)logger, (String)Resource.class.getName(), (String)"testAttribute", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "target: " + target.getClass().getName(), "name: " + name, "value: " + value});
        if (this.equals(target) && DB_VERSION_GREATER_OR_EQUALS.equals(name)) {
            Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"testAttribute", (Object)("return " + Resource.isDbVersionAcceptable(value)));
            return Resource.isDbVersionAcceptable(value);
        }
        Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"testAttribute", (Object)"return false");
        return false;
    }

    public void clearSourceInteractions() {
        this.sourceInteractions = null;
        this.sourceProgramInteractions = null;
        this.sourceTransactionInteractions = null;
    }

    public void clearTargetInteractions() {
    }

    public static boolean isDbVersionAcceptable(String value) {
        Debug.enter((Logger)logger, (String)Resource.class.getName(), (String)"isDbVersionAcceptable", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "value: " + value});
        int version = 0;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Debug.warning((Logger)logger, (String)Resource.class.getName(), (String)"isDbVersionAcceptable", (String)"exit from method", (Throwable)e);
            Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"isDbVersionAcceptable", (Object)"return false");
            return false;
        }
        boolean result = Version.getInstance().getDBVersion() >= version;
        Debug.exit((Logger)logger, (String)Resource.class.getName(), (String)"isDbVersionAcceptable", (Object)("return " + result));
        return result;
    }

    public abstract List getProperties();

    public abstract List getSourceInteractions();

    public abstract List getSourceProgramInteractions();

    public abstract List getSourceTransactionInteractions();

    public abstract Command createGetRegionsCommand();

    public abstract Command createGetPlatformsCommand();
}

