/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class RegionAndResource
implements Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(RegionAndResource.class.getPackage().getName());
    private static final long serialVersionUID = 2402645539647743711L;
    protected Region region;
    protected Resource resource;

    public RegionAndResource(Region region, Resource resource) {
        this.region = region;
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Region getRegion() {
        return this.region;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionAndResource other = (RegionAndResource)obj;
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public static List inFirstListNotInSecond(List firstList, List secondList) {
        Debug.enter((Logger)logger, (String)RegionAndResource.class.getName(), (String)"inFirstListNotInSecond", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<Resource> resourcesSecondList = new ArrayList<Resource>(secondList.size());
        Iterator iter = secondList.iterator();
        while (iter.hasNext()) {
            Resource resource = ((RegionAndResource)iter.next()).getResource();
            if (resourcesSecondList.contains(resource)) continue;
            resourcesSecondList.add(resource);
        }
        ArrayList<RegionAndResource> result = new ArrayList<RegionAndResource>(firstList.size() / 2);
        for (RegionAndResource regionAndResource : firstList) {
            if (resourcesSecondList.contains(regionAndResource.getResource())) continue;
            result.add(regionAndResource);
        }
        Debug.exit((Logger)logger, (String)RegionAndResource.class.getName(), (String)"inFirstListNotInSecond");
        return result;
    }

    public String getAsTitleCopyString() {
        return "Region,Type,Resource";
    }

    public String getAsCopyString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.region.getName());
        buffer.append(',');
        buffer.append(this.resource.getTypeName());
        buffer.append(',');
        buffer.append(this.resource.getName());
        return buffer.toString();
    }

    public static String toCopyString(List results) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = results.iterator();
        int count = 0;
        while (iter.hasNext()) {
            RegionAndResource interaction = (RegionAndResource)iter.next();
            if (count == 0) {
                buffer.append(interaction.getAsTitleCopyString());
                buffer.append(IAUtilities.LINE_SEPARATOR);
            }
            ++count;
            buffer.append(interaction.getAsCopyString());
            buffer.append(IAUtilities.LINE_SEPARATOR);
        }
        return buffer.toString();
    }
}

