/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.PropertiesCommand;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.CICSResource;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.RegionPropertySource;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertySource;

public class Region
extends CICSResource
implements IActionFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Region.class.getPackage().getName());
    private List properties;
    private CintCollector cintCollector = null;

    public Region(String resourceName) {
        super("APPLID", resourceName);
    }

    @Override
    public List getProperties() {
        Debug.enter((Logger)logger, (String)Region.class.getName(), (String)"getProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PropertiesCommand command = new PropertiesCommand(this);
        command.start();
        this.properties = command.getResults();
        Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"getProperties", (Object)("properties size: " + this.properties.size()));
        return this.properties;
    }

    @Override
    public Object getAdapter(Class adapterType) {
        Debug.enter((Logger)logger, (String)Region.class.getName(), (String)"getAdapter", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "adapterType: " + adapterType.getName()});
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new RegionPropertySource(this);
            }
            Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"getAdapter", (Object)("propertySource: " + this.propertySource.getClass().getName()));
            return this.propertySource;
        }
        Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"getAdapter", (Object)("super.getAdapter(adapterType)" + (super.getAdapter(adapterType) != null ? super.getAdapter(adapterType).getClass().getName() : super.getAdapter(adapterType))));
        return super.getAdapter(adapterType);
    }

    public void setCintCollector(CintCollector aCintCollector) {
        this.cintCollector = aCintCollector;
    }

    public CintCollector getCollector() {
        return this.cintCollector;
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        Debug.enter((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "target: " + target.getClass().getName(), "name: " + name, "value: " + value});
        if (this.equals(target) && this.cintCollector != null) {
            if (name.equals("START_ACTION") && this.cintCollector.getState().equals("STOPPED")) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
            if (name.equals("STOP_ACTION") && (this.cintCollector.getState().equals("RUNNING") || this.cintCollector.getState().equals("PAUSED") || this.cintCollector.getState().equals("FAILING") || this.cintCollector.getState().equals("STOPFAIL"))) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
            if (name.equals("PAUSE_ACTION") && this.cintCollector.getState().equals("RUNNING")) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
            if (name.equals("CONTINUE_ACTION") && this.cintCollector.getState().equals("PAUSED")) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
            if (name.equals("EDIT_COLLECTOR_OPTIONS") && this.cintCollector.getState().equals("STOPPED")) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
            if (name.equals("START_SCENARIO_BASED_COLLECTION") && !this.cintCollector.isConnectedToAtom() && this.cintCollector.getState().equals("STOPPED")) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
            if (name.equals(WebServiceRequest.CINT_RESET_REGION_DEFAULTS_ACTION) && !this.cintCollector.isConnectedToAtom() && this.cintCollector.getState().equals("STOPPED")) {
                Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return true, name: " + name));
                return true;
            }
        }
        boolean result = super.testAttribute(target, name, value);
        Debug.exit((Logger)logger, (String)Region.class.getName(), (String)"testAttribute", (Object)("return " + result));
        return result;
    }
}

