/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import java.util.logging.Logger;
import org.eclipse.ui.IActionFilter;

public class Operation
implements IActionFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Operation.class.getPackage().getName());
    private TSApplication application;
    private String name;

    public Operation(TSApplication application, String name) {
        this.name = name;
        this.application = application;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)o;
        return operation.name.equals(this.name) && operation.application.getFullName().equals(this.application.getFullName());
    }

    public int hashCode() {
        int shift = 31;
        return this.name.hashCode() * shift + this.application.getFullName().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public TSApplication getApplication() {
        return this.application;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApplication(TSApplication application) {
        this.application = application;
    }

    public String toString() {
        return String.valueOf(this.application.toString()) + " (" + this.name + ")";
    }

    public boolean testAttribute(Object target, String name, String value) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"testAttribute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.equals(target) && "DB_VERSION_GREATER_OR_EQUALS".equals(name)) {
            return Resource.isDbVersionAcceptable(value);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"testAttribute");
        return false;
    }
}

