/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.PlatformsForResourceCommand;
import com.ibm.cics.ia.commands.RegionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceInteractionsForIMSResourceCommand;
import com.ibm.cics.ia.commands.SourceProgramInteractionsForIMSResourceCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForIMSResourceCommand;
import com.ibm.cics.ia.model.Resource;
import java.util.List;
import java.util.logging.Logger;

public class IMSResource
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IMSResource.class.getPackage().getName());
    private static final long serialVersionUID = -2123544884839756799L;

    public IMSResource(String resourceTypeName, String resourceName) {
        super(resourceTypeName, resourceName);
    }

    @Override
    public synchronized List getSourceInteractions() {
        Debug.enter((Logger)logger, (String)IMSResource.class.getName(), (String)"getSourceInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceInteractions == null) {
            SourceInteractionsForIMSResourceCommand command = new SourceInteractionsForIMSResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)IMSResource.class.getName(), (String)"getSourceInteractions");
        return this.sourceInteractions;
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForResourceCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return new PlatformsForResourceCommand(this);
    }

    @Override
    public List getProperties() {
        return null;
    }

    @Override
    public synchronized List getSourceProgramInteractions() {
        if (this.sourceProgramInteractions == null) {
            SourceProgramInteractionsForIMSResourceCommand command = new SourceProgramInteractionsForIMSResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceProgramInteractions = command.getResults();
        }
        return this.sourceProgramInteractions;
    }

    @Override
    public synchronized List getSourceTransactionInteractions() {
        if (this.sourceTransactionInteractions == null) {
            SourceTransactionInteractionsForIMSResourceCommand command = new SourceTransactionInteractionsForIMSResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceTransactionInteractions = command.getResults();
        }
        return this.sourceTransactionInteractions;
    }
}

