/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FilePropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FilePropertySource.class.getPackage().getName());
    public static final String APPLID = "APPLID";
    public static final String HOMESYSID = "HOMESYSID";
    public static final String FILE_NAME = "FILE_NAME";
    public static final String ACCESSMETHOD = "ACCESSMETHOD";
    public static final String BASEDSNAME = "BASEDSNAME";
    public static final String BLOCKFORMAT = "BLOCKFORMAT";
    public static final String BLOCKKEYLEN = "BLOCKKEYLEN";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String CFDTPOOL = "CFDTPOOL";
    public static final String DISPOSITION = "DISPOSITION";
    public static final String DSNAME = "DSNAME";
    public static final String JOURNALNUM = "JOURNALNUM";
    public static final String KEYLENGTH = "KEYLENGTH";
    public static final String KEYPOSITION = "KEYPOSITION";
    public static final String LOADTYPE = "LOADTYPE";
    public static final String LSRPOOLID = "LSRPOOLID";
    public static final String MAXNUMRECS = "MAXNUMRECS";
    public static final String OBJECT = "OBJECT";
    public static final String RBATYPE = "RBATYPE";
    public static final String RECORDFORMAT = "RECORDFORMAT";
    public static final String RECORDSIZE = "RECORDSIZE";
    public static final String RECOVSTATUS = "RECOVSTATUS";
    public static final String RELTYPE = "RELTYPE";
    public static final String REMOTENAME = "REMOTENAME";
    public static final String REMOTESYSTEM = "REMOTESYSTEM";
    public static final String REMOTETABLE = "REMOTETABLE";
    public static final String RLSACCESS = "RLSACCESS";
    public static final String STRINGS = "STRINGS";
    public static final String TABLE = "TABLE";
    public static final String TABLENAME = "TABLENAME";
    public static final String TYPE = "TYPE";
    public static final String FIRST_RUN = "FIRST_RUN";
    public static final String LAST_RUN = "LAST_RUN";
    public static final String COLLECTION_ID = "COLLECTION_ID";
    public static final String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static String APPL_NAME = "APPL_NAME";
    private static String APPL_VER1 = "APPL_VER1";
    private static String APPL_VER2 = "APPL_VER2";
    private static String APPL_VER3 = "APPL_VER3";
    private static String APPL_OPER = "APPL_OPER";
    private static String PLATFORM = "PLATFORM";
    private static final String[] ia31propertyIDs = new String[]{"APPLID", "HOMESYSID", "FILE_NAME", "ACCESSMETHOD", "BASEDSNAME", "BLOCKFORMAT", "BLOCKKEYLEN", "BLOCKSIZE", "CFDTPOOL", "DISPOSITION", "DSNAME", "JOURNALNUM", "KEYLENGTH", "KEYPOSITION", "LOADTYPE", "LSRPOOLID", "MAXNUMRECS", "OBJECT", "RBATYPE", "RECORDFORMAT", "RECORDSIZE", "RECOVSTATUS", "RELTYPE", "REMOTENAME", "REMOTESYSTEM", "REMOTETABLE", "RLSACCESS", "STRINGS", "TABLE", "TABLENAME", "TYPE", "FIRST_RUN", "LAST_RUN"};
    private static final String[] ia32propertyIDs = IAUtilities.concat(ia31propertyIDs, new String[][]{{"COLLECTION_ID", "ARCHIVE_DATE"}});
    private static final String[] ia51propertyIDs = IAUtilities.concat(ia32propertyIDs, new String[][]{{APPL_NAME, APPL_VER1, APPL_VER2, APPL_VER3, APPL_OPER}});
    private static final String[] ia52propertyIDs = IAUtilities.concat(ia51propertyIDs, new String[][]{{PLATFORM}});

    public FilePropertySource(Resource resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)FilePropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null && !this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            List properties = this.resource.getProperties();
            this.processProperties(properties);
        }
        Debug.exit((Logger)logger, (String)FilePropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.getPropertiesInCurrentCollectionId();
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)FilePropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] propertyIDs = FilePropertySource.getPropertyIDs();
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map m = (Map)properties.get(i);
            ArrayList<PropertyDescriptor> descriptors = (ArrayList<PropertyDescriptor>)this.collectionID2Props.get((String)m.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<PropertyDescriptor>();
                this.collectionID2Props.put((String)m.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: {
                    categoryName = MessageFormat.format(Messages.getString("FilePropertySource.3200"), (String)m.get(FILE_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID));
                    break;
                }
                case 5100: 
                case 5110: {
                    String ver1 = (String)m.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)m.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)m.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(null, (String)m.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("FilePropertySource.3200"), (String)m.get(FILE_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID))) + ", " + app1.getFullName() + " (" + m.get(APPL_OPER) + ")";
                    break;
                }
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    String ver1 = (String)m.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)m.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)m.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(new Platform((String)m.get(PLATFORM)), (String)m.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("FilePropertySource.3200"), (String)m.get(FILE_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID))) + ", " + m.get(PLATFORM) + ", " + app1.getFullName() + " (" + m.get(APPL_OPER) + ")";
                    break;
                }
                case 3100: {
                    categoryName = MessageFormat.format(Messages.getString("FilePropertySource.3100"), (String)m.get(FILE_NAME), (String)m.get(APPLID));
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("FilePropertySource.3100"), (String)m.get(FILE_NAME), (String)m.get(APPLID));
                }
            }
            int j = 0;
            while (j < propertyIDs.length) {
                String key = propertyIDs[j];
                String newKey = String.valueOf(key) + m.get(COLLECTION_ID) + m.get(APPLID) + "_" + Integer.toString(i);
                this.values.put(newKey, m.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(propertyIDs[j]));
                descriptor.setCategory(categoryName);
                descriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)FilePropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return FilePropertySource.getPropertyIDs().length;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3100: {
                return ia31propertyIDs;
            }
            case 3200: {
                return ia32propertyIDs;
            }
            case 5100: 
            case 5110: {
                return ia51propertyIDs;
            }
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia52propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

