/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExitPropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ExitPropertySource.class.getPackage().getName());
    private static final String APPLID = "APPLID";
    private static final String HOMESYSID = "HOMESYSID";
    private static final String EXIT_PROGRAM = "EXIT_PROGRAM";
    private static final String EXIT_NAME = "EXIT_NAME";
    private static final String EXIT_POINT = "EXIT_POINT";
    private static final String EXIT_TYPE = "EXIT_TYPE";
    private static final String FIRST_RUN = "FIRST_RUN";
    private static final String LAST_RUN = "LAST_RUN";
    private static final String PRODUCT_INFO = "PRODUCT_INFO";
    private static final String COLLECTION_ID = "COLLECTION_ID";
    private static final String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static final String[] ia31propertyIDs = new String[]{"APPLID", "HOMESYSID", "EXIT_PROGRAM", "EXIT_NAME", "EXIT_POINT", "EXIT_TYPE", "FIRST_RUN", "LAST_RUN", "PRODUCT_INFO"};
    private static final String[] ia32propertyIDs = IAUtilities.concat(new String[]{"COLLECTION_ID", "ARCHIVE_DATE"}, new String[][]{ia31propertyIDs});

    public ExitPropertySource(Resource resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)ExitPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null && !this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            List properties = this.resource.getProperties();
            this.processProperties(properties);
        }
        Debug.exit((Logger)logger, (String)ExitPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.getPropertiesInCurrentCollectionId();
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)ExitPropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] propertyIDs = ExitPropertySource.getPropertyIDs();
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map m = (Map)properties.get(i);
            ArrayList<PropertyDescriptor> descriptors = (ArrayList<PropertyDescriptor>)this.collectionID2Props.get((String)m.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<PropertyDescriptor>();
                this.collectionID2Props.put((String)m.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: 
                case 5100: 
                case 5110: 
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    categoryName = MessageFormat.format(Messages.getString("ExitPropertySource.3200"), (String)m.get(EXIT_PROGRAM), (String)m.get(EXIT_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID));
                    break;
                }
                case 3100: {
                    categoryName = MessageFormat.format(Messages.getString("ExitPropertySource.3100"), (String)m.get(EXIT_PROGRAM), (String)m.get(EXIT_NAME), (String)m.get(APPLID));
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("ExitPropertySource.3100"), (String)m.get(EXIT_PROGRAM), (String)m.get(EXIT_NAME), (String)m.get(APPLID));
                }
            }
            int j = 0;
            while (j < ExitPropertySource.getPropertyCount()) {
                String key = propertyIDs[j];
                String newKey = String.valueOf(key) + m.get(COLLECTION_ID) + m.get(APPLID) + m.get(EXIT_PROGRAM) + m.get(EXIT_NAME) + "_" + Integer.toString(i);
                this.values.put(newKey, m.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(propertyIDs[j]));
                descriptor.setCategory(categoryName);
                descriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)ExitPropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return ExitPropertySource.getPropertyIDs().length;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3100: {
                return ia31propertyIDs;
            }
            case 3200: 
            case 5100: 
            case 5110: 
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia32propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

