/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.Manifest;
import com.ibm.cics.bundle.core.BundleProjectNature;
import com.ibm.cics.bundle.core.CICSBundleException;
import com.ibm.cics.bundle.core.CICSBundleProject;
import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.bundle.ui.BundleUIMessages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.model.ProgramType;
import com.ibm.cics.ia.model.CicsBundleResource;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModel;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public abstract class EntryPointsModelBaseImpl
implements EntryPointsModel {
    private static final Logger logger = Logger.getLogger(EntryPointsModelBaseImpl.class.getPackage().getName());
    static final String OPER_SUFFIX = "_OPER";
    protected List<EntryPoint> entryPoints = new ArrayList<EntryPoint>();
    protected CICSBundleProject currentProject;
    protected String currentProjectName;
    private Map<String, List<EntryPoint>> projectToEntryPoints = new HashMap<String, List<EntryPoint>>();
    private EntryPointsModel.CallType callTypeParam;
    private EntryPointsModel.CicsTsLevel cicsTsLevel;
    private String regionParam;
    private String objectType1Param;
    private String objectType2Param;
    protected Object resource;

    @Override
    public abstract List<EntryPoint> getFreshEntryPoints();

    @Override
    public void addEntryPointsToProject() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"addEntryPointsToProject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.currentProjectName != null) {
            this.addEntryPoints(ResourcesPlugin.getWorkspace().getRoot().getProject(this.currentProjectName));
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"addEntryPointsToProject");
    }

    @Override
    public void setProjectName(String projectName) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setProjectName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.currentProjectName = projectName;
        if (this.currentProjectName != null) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.currentProjectName);
            this.currentProject = new CICSBundleProject(iProject);
        } else {
            this.currentProject = null;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setProjectName");
    }

    protected List<EntryPoint> getCurrentProjectEntryPoints() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentProjectDependencies", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List<EntryPoint> entryPoints = new ArrayList<EntryPoint>();
        if (this.currentProject != null && (entryPoints = this.projectToEntryPoints.get(this.currentProject.getProject().getName())) == null) {
            entryPoints = new ArrayList();
            try {
                for (Manifest.Modify modify : this.currentProject.getManifestImpl().getModify()) {
                    Manifest.Modify.Entrypoint projectEntryPoint = modify.getEntrypoint();
                    EntryPoint dependency = new EntryPoint(projectEntryPoint.getName(), projectEntryPoint.getOperation(), projectEntryPoint.getType(), new HashMap<String, String>());
                    EntryPoint convertedEntryPoint = new EntryPoint(projectEntryPoint.getName(), projectEntryPoint.getOperation(), projectEntryPoint.getType(), new HashMap<String, String>());
                    entryPoints.add(convertedEntryPoint);
                }
                this.projectToEntryPoints.put(this.currentProject.getProject().getName(), entryPoints);
            }
            catch (CICSBundleException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentProjectDependencies", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to get the current project entry points", e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentProjectDependencies");
        return entryPoints;
    }

    private boolean containsInvalidCharsInOper(EntryPoint entryPoint) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInOper", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            if (entryPoint.getOperation().isEmpty()) {
                throw new IllegalArgumentException(Messages.getString("ApplicationCreationModel.error.operationEmpty"));
            }
            int operation_max_length = 64;
            String regularExpression = "[a-zA-Z0-9._#@-]+";
            SimpleValidationHelper.validateMaxLength((String)entryPoint.getOperation(), (int)operation_max_length, (String)BundleUIMessages.EntryPointDialog_operationLabel);
            SimpleValidationHelper.validateWhiteSpace((String)entryPoint.getOperation(), (String)"a-z, A-Z, 0-9, ._#@-", (String)BundleUIMessages.EntryPointDialog_operationLabel);
            SimpleValidationHelper.validateCharacters((String)entryPoint.getOperation(), (String)regularExpression, (String)"a-z, A-Z, 0-9, ._#@-", (String)BundleUIMessages.EntryPointDialog_operationLabel);
        }
        catch (IllegalArgumentException e) {
            entryPoint.setError(e.getMessage());
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInOper");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInOper");
        return false;
    }

    public static String isValidOperation(String operation) {
        Debug.enter((Logger)logger, (String)EntryPointsModelBaseImpl.class.getName(), (String)"isValidOperation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            if (operation.isEmpty()) {
                throw new IllegalArgumentException(Messages.getString("ApplicationCreationModel.error.operationEmpty"));
            }
            int operation_max_length = 64;
            String regularExpression = "[a-zA-Z0-9._#@-]+";
            SimpleValidationHelper.validateMaxLength((String)operation, (int)operation_max_length, (String)BundleUIMessages.EntryPointDialog_operationLabel);
            SimpleValidationHelper.validateWhiteSpace((String)operation, (String)"a-z, A-Z, 0-9, ._#@-", (String)BundleUIMessages.EntryPointDialog_operationLabel);
            SimpleValidationHelper.validateCharacters((String)operation, (String)regularExpression, (String)"a-z, A-Z, 0-9, ._#@-", (String)BundleUIMessages.EntryPointDialog_operationLabel);
        }
        catch (IllegalArgumentException e) {
            Debug.exit((Logger)logger, (String)EntryPointsModelBaseImpl.class.getName(), (String)"isValidOperation");
            return e.getMessage();
        }
        Debug.exit((Logger)logger, (String)EntryPointsModelBaseImpl.class.getName(), (String)"isValidOperation");
        return null;
    }

    public boolean containsInvalidCharsInNameOrOper(EntryPoint entryPoint) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInNameOrOper", (Object)("Thread ID: " + Thread.currentThread().getId()));
        BundleTypeHelper.BundlePartType bundlePartType = entryPoint.getBundlePartType();
        ICICSType type = BundleTypeHelper.getCICSType((String)bundlePartType.getBundlePartTypeName());
        ICICSAttribute attr = type.findAttributeByCicsName(type.getNameAttribute());
        try {
            if (attr.getValuesHint().hasMaxLength()) {
                SimpleValidationHelper.validateMaxLength((String)entryPoint.getName(), (int)attr.getValuesHint().getMaxLength(), (String)BundleUIMessages.EntryPointDialog_nameLabel);
            }
            SimpleValidationHelper.validateCharacters((String)entryPoint.getName(), (String)bundlePartType.getNameValidExpression(), (String)bundlePartType.getNameValidCharacter(), (String)BundleUIMessages.EntryPointDialog_nameLabel);
            if (bundlePartType.getResourceTableName() == ProgramType.getInstance().getResourceTableName()) {
                SimpleValidationHelper.validateNotToStartWith((String)entryPoint.getName(), (String)BundleUIMessages.EntryPointDialog_nameLabel, (String)"DFH");
            }
            if (entryPoint.getName().isEmpty()) {
                throw new IllegalArgumentException(Messages.getString("ApplicationCreationModel.error.resourceNameEmpty"));
            }
        }
        catch (IllegalArgumentException e) {
            entryPoint.setError(e.getMessage());
            return true;
        }
        if (StringUtil.containsNonLatin1PrintableChars((String)entryPoint.getName())) {
            entryPoint.setError(String.valueOf(BundleUIMessages.EntryPointDialog_nameLabel) + ": " + BundleUIMessages.EntryPointDialog_unprintableCharMessage);
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInNameOrOper");
            return true;
        }
        try {
            attr.validate((Object)entryPoint.getName());
        }
        catch (IllegalCICSAttributeException e) {
            entryPoint.setError(String.valueOf(BundleUIMessages.EntryPointDialog_nameLabel) + ": " + BundleUIMessages.bind((String)BundleUIMessages.EntryPointDialog_invalidNameMessage, (Object)e.getMessage()));
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInNameOrOper");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"containsInvalidCharsInNameOrOper");
        return this.containsInvalidCharsInOper(entryPoint);
    }

    @Override
    public String[] getCicsBundleProjectNames() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getCicsBundleProjectNames", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<String> projectNames = new ArrayList<String>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.hasNature("com.ibm.cics.bundle.ui.bundlenature") && BundleProjectNature.hasBundleBuilder((IProject)project)) {
                    projectNames.add(project.getName());
                }
            }
            catch (CoreException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"getCicsBundleProjectNames", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to get the CICS bundle projects", e);
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getCicsBundleProjectNames");
        return projectNames.toArray(new String[projectNames.size()]);
    }

    @Override
    public String getProjectName() {
        return this.currentProjectName;
    }

    @Override
    public void setCallTypeParam(EntryPointsModel.CallType callType) {
        this.callTypeParam = callType;
    }

    @Override
    public void setRegionParam(String region) {
        this.regionParam = region;
    }

    protected void addEntryPoints(IProject project) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"addEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CICSBundleProject cicsBundleProject = new CICSBundleProject(project);
        for (EntryPoint entryPoint : this.entryPoints) {
            if (!entryPoint.isSelected() || !entryPoint.isEnabled()) continue;
            Manifest.Modify modify = new Manifest.Modify();
            Manifest.Modify.Entrypoint entrypoint = new Manifest.Modify.Entrypoint();
            entrypoint.setName(entryPoint.getName());
            entrypoint.setOperation(entryPoint.getOperation());
            entrypoint.setType(entryPoint.getBundlePartType().getBundlePartTypeName());
            modify.setEntrypoint(entrypoint);
            try {
                cicsBundleProject.getManifestImpl().getModify().add(modify);
            }
            catch (CICSBundleException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"addEntryPoints", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to add entry points to the CICS bundle project", e);
            }
        }
        try {
            cicsBundleProject.setManifestImpl(cicsBundleProject.getManifestImpl());
        }
        catch (CICSBundleException e) {
            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"addEntryPoints", (Throwable)e);
            IAPlugin.getDefault().logError("Unable to add entry points to the CICS bundle project", e);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"addEntryPoints");
    }

    @Override
    public void validateResources() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"validateEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.entryPoints.size()) {
            List<EntryPoint> projEntryPoints;
            EntryPoint entryPoint = this.entryPoints.get(i);
            entryPoint.setError(null);
            if (entryPoint.isSelected() && entryPoint.isEnabled() && !this.containsInvalidCharsInOper(entryPoint) && (projEntryPoints = this.getCurrentProjectEntryPoints()).contains(entryPoint)) {
                entryPoint.setError(BundleUIMessages.EntryPointDialog_alreadyExistsMessage);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"validateEntryPoints");
    }

    @Override
    public boolean hasInvalidResources() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"hasInvalidEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (EntryPoint entryPoint : this.entryPoints) {
            if (!entryPoint.isEnabled() || !entryPoint.isSelected() || entryPoint.getError() == null) continue;
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasInvalidEntryPoints");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasInvalidEntryPoints");
        return false;
    }

    @Override
    public EntryPointsModel.CallType getCallTypeParam() {
        return this.callTypeParam;
    }

    @Override
    public String getRegionParam() {
        return this.regionParam;
    }

    @Override
    public List<EntryPoint> getCachedEntryPoints() {
        return this.entryPoints;
    }

    public void setEntryPoints(List<EntryPoint> entryPoints) {
        this.entryPoints = entryPoints;
    }

    @Override
    public void setCicsTsLevel(EntryPointsModel.CicsTsLevel cicsTsLevel) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setCicsTsLevel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.cicsTsLevel = cicsTsLevel;
        this.enableEntryPointsBasedOnCicsTsLevel();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setCicsTsLevel");
    }

    @Override
    public EntryPointsModel.CicsTsLevel getCicsTsLevel() {
        return this.cicsTsLevel;
    }

    protected void enableEntryPointsBasedOnCicsTsLevel() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"enableEntryPointsBasedOnCicsTsLevel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<BundleTypeHelper.BundlePartType> enabledEntryPointTypes = new ArrayList<BundleTypeHelper.BundlePartType>();
        switch (this.cicsTsLevel) {
            case LEVEL_53: 
            case LEVEL_55: 
            case LEVEL_56: 
            case LEVEL_61: 
            case LEVEL_62: 
            case LEVEL_63: {
                enabledEntryPointTypes.add(BundleTypeHelper.BundlePartType.TRANSACTION);
            }
            case LEVEL_52: {
                enabledEntryPointTypes.add(BundleTypeHelper.BundlePartType.URIMAP);
            }
            case LEVEL_51: {
                enabledEntryPointTypes.add(BundleTypeHelper.BundlePartType.PROGRAM);
            }
        }
        for (EntryPoint entryPoint : this.entryPoints) {
            entryPoint.setEnabled(enabledEntryPointTypes.contains(entryPoint.getBundlePartType()));
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"enableEntryPointsBasedOnCicsTsLevel");
    }

    @Override
    public void setObjectType1Param(String objectType1) {
        this.objectType1Param = objectType1;
    }

    @Override
    public String getObjectType1Param() {
        return this.objectType1Param;
    }

    @Override
    public void setObjectType2Param(String objectType2) {
        this.objectType2Param = objectType2;
    }

    @Override
    public String getObjectType2Param() {
        return this.objectType2Param;
    }

    @Override
    public List<CicsBundleResource> getCachedDependencies() {
        return null;
    }

    @Override
    public List<CicsBundleResource> getFreshDependencies() {
        return null;
    }

    @Override
    public void addDependenciesToProject() {
    }

    @Override
    public String hasValidName(CicsBundleResource dependency) {
        return null;
    }

    @Override
    public String availableInCurrentProject(CicsBundleResource dependency) {
        return null;
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Object resource) {
        this.resource = resource;
    }
}

