/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.ia.model.EntryPoint;
import java.util.ArrayList;

public class EntryPointTreeItem {
    private ArrayList<EntryPointTreeItem> children;
    private EntryPointTreeItem parent;
    private String type;
    private String name;
    private String operation;
    private String collectionID;
    private String region;
    private String platform;
    private String application;
    private String applOperation;
    private boolean selected;
    private String error;
    private boolean isDependency;
    private EntryPoint entryPoint;

    public EntryPointTreeItem(EntryPoint entryPoint) {
        this.entryPoint = new EntryPoint(entryPoint);
        this.type = entryPoint.getUserFriendlyType();
        this.name = entryPoint.getName();
        this.operation = entryPoint.getOperation();
        this.collectionID = entryPoint.getCollectionId();
        this.region = entryPoint.getApplid();
        this.platform = entryPoint.getPlatform();
        this.application = entryPoint.getFullApplName();
        this.applOperation = entryPoint.getApplOperation();
        this.selected = entryPoint.isSelected();
        this.children = new ArrayList();
        this.parent = null;
        this.isDependency = entryPoint.getIsDependency();
        this.error = entryPoint.getError();
    }

    public EntryPointTreeItem(EntryPointTreeItem entryPointTreeItem) {
        this(entryPointTreeItem.getEntryPoint());
        this.children = entryPointTreeItem.getChildren();
        this.parent = entryPointTreeItem.getParent();
        this.isDependency = false;
    }

    public void addChildren(ArrayList<EntryPointTreeItem> newChildren) {
        this.children.addAll(newChildren);
    }

    public void addChidren(EntryPointTreeItem newChild) {
        this.error = null;
        this.children.add(newChild);
    }

    public void setChildren(ArrayList<EntryPointTreeItem> newChildren) {
        this.children.clear();
        this.children = newChildren;
        this.setError(null);
    }

    public ArrayList<EntryPointTreeItem> getChildren() {
        return this.children;
    }

    public EntryPointTreeItem getParent() {
        return this.parent;
    }

    public void setParent(EntryPointTreeItem parent) {
        this.parent = parent;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isSelected() {
        return this.entryPoint == null ? this.selected : this.entryPoint.isSelected();
    }

    public boolean isEnabled() {
        if (!this.children.isEmpty()) {
            return this.children.get(0).isEnabled();
        }
        return this.entryPoint.isEnabled();
    }

    public EntryPoint getEntryPoint() {
        if (this.entryPoint != null) {
            return this.entryPoint;
        }
        return this.children.get(0).getEntryPoint();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.getEntryPoint().setUserFriendlyType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.getEntryPoint().setName(name);
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
        if (this.entryPoint != null) {
            this.entryPoint.setOperation(operation);
        } else if (this.children.size() > 0) {
            for (EntryPointTreeItem child : this.children) {
                child.setOperation(operation);
            }
        }
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplOperation() {
        return this.applOperation;
    }

    public void setApplOperation(String applOperation) {
        this.applOperation = applOperation;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
        if (this.entryPoint != null) {
            this.entryPoint.setSelected(isSelected);
        }
        int i = 0;
        while (i < this.children.size()) {
            EntryPointTreeItem child = this.children.get(i);
            child.setSelected(isSelected);
            ++i;
        }
    }

    public String getError() {
        if (this.entryPoint != null) {
            return this.entryPoint.getError();
        }
        return null;
    }

    public void setError(String error) {
        if (this.entryPoint != null) {
            this.entryPoint.setError(error);
            this.error = error;
        } else if (this.children.size() > 0) {
            for (EntryPointTreeItem child : this.children) {
                child.setError(error);
            }
        }
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String getObject() {
        return this.entryPoint != null ? this.entryPoint.getObject() : "";
    }

    public void setIsDependency(boolean isDep) {
        this.isDependency = isDep;
    }

    public boolean getIsDependency() {
        return this.isDependency;
    }

    public boolean equals(EntryPointTreeItem item) {
        return this.entryPoint != null && this.entryPoint.equals(item.getEntryPoint());
    }
}

