/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.ia.model.CicsBundleResource;
import java.util.Map;

public class EntryPoint
extends CicsBundleResource {
    private String operation;
    private boolean enabled;
    private boolean isDependency;
    private CicsBundleResource dep;

    public EntryPoint(String name, String operation, String typeName, Map<String, String> additionalAttributes) {
        super(name, typeName, additionalAttributes);
        this.operation = operation;
        this.isDependency = false;
    }

    public EntryPoint(String name, String operation, BundleTypeHelper.BundlePartType bundlePartType, Map<String, String> additionalAttributes) {
        super(name, bundlePartType, additionalAttributes);
        this.operation = operation;
        this.isDependency = false;
    }

    public EntryPoint(EntryPoint entryPoint) {
        this(entryPoint.getName(), entryPoint.getOperation(), entryPoint.getUserFriendlyType(), entryPoint.getAdditionalAttributes());
        this.setEnabled(entryPoint.isEnabled());
        this.setSelected(entryPoint.isSelected());
        this.setError(entryPoint.getError());
        this.setIsDep(entryPoint.getIsDependency());
        this.setDep(entryPoint.getDep());
        this.setUserFriendlyType(entryPoint.getUserFriendlyType());
        this.setBundlePartType(entryPoint.getBundlePartType());
    }

    private CicsBundleResource getDep() {
        return this.dep;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIsDep(boolean isDep) {
        this.isDependency = isDep;
    }

    public boolean getIsDependency() {
        return this.isDependency;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.dep != null) {
            this.dep.setSelected(selected);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.dep != null && (this.dep.getUserFriendlyType().equals(BundleTypeHelper.BundlePartType.DB2CONN.name()) || this.dep.getUserFriendlyType().equals(BundleTypeHelper.BundlePartType.MQCONN.name()))) {
            this.dep.setName(name);
        }
    }

    public boolean equals(EntryPoint entry) {
        return this.getApplid().equals(entry.getApplid()) && this.getApplOperation() != null && this.getApplOperation().equals(entry.getApplOperation()) && this.getCollectionId().equals(entry.getCollectionId()) && this.getName().equals(entry.getName()) && this.getFullApplName().equals(entry.getFullApplName()) && this.getBundlePartType().equals((Object)entry.getBundlePartType()) && this.getPlatform().equals(entry.getPlatform()) && this.getIsDependency() == entry.getIsDependency() && this.getUserFriendlyType().equals(entry.getUserFriendlyType());
    }

    public void setDep(CicsBundleResource dep) {
        this.dep = dep;
    }
}

