/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.PlatformsForResourceCommand;
import com.ibm.cics.ia.commands.RegionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceInteractionsForDB2ResourceCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForDB2ResourceCommand;
import com.ibm.cics.ia.model.Resource;
import java.util.List;
import java.util.logging.Logger;

public class DB2Resource
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DB2Resource.class.getPackage().getName());
    private static final long serialVersionUID = -2123544884839756799L;

    public DB2Resource(String resourceTypeName, String resourceName) {
        super(resourceTypeName, resourceName);
    }

    @Override
    public synchronized List getSourceInteractions() {
        Debug.enter((Logger)logger, (String)DB2Resource.class.getName(), (String)"getSourceInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceInteractions == null) {
            SourceInteractionsForDB2ResourceCommand command = new SourceInteractionsForDB2ResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)DB2Resource.class.getName(), (String)"getSourceInteractions");
        return this.sourceInteractions;
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForResourceCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return new PlatformsForResourceCommand(this);
    }

    @Override
    public List getProperties() {
        return null;
    }

    @Override
    public synchronized List getSourceProgramInteractions() {
        Debug.enter((Logger)logger, (String)DB2Resource.class.getName(), (String)"getSourceProgramInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceProgramInteractions == null) {
            SourceInteractionsForDB2ResourceCommand command = new SourceInteractionsForDB2ResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceProgramInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)DB2Resource.class.getName(), (String)"getSourceProgramInteractions");
        return this.sourceProgramInteractions;
    }

    @Override
    public synchronized List getSourceTransactionInteractions() {
        Debug.enter((Logger)logger, (String)DB2Resource.class.getName(), (String)"getSourceTransactionInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceTransactionInteractions == null) {
            SourceTransactionInteractionsForDB2ResourceCommand command = new SourceTransactionInteractionsForDB2ResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceTransactionInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)DB2Resource.class.getName(), (String)"getSourceTransactionInteractions");
        return this.sourceTransactionInteractions;
    }
}

