/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceAndVerb;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CommandExecution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandExecution.class.getPackage().getName());
    private static final long serialVersionUID = -6741965491690174570L;
    private static final String OKRESPONSE = "00000000";
    private Task task;
    private Transaction transaction;
    private Timestamp commandTime;
    private String distributedUOW;
    private Region region;
    private Program program;
    private String prevTCBMode;
    private String tcbMode;
    private ResourceAndVerb resourceAndVerb;
    private boolean isError;
    private String RESP;
    private String RESP2;
    private Map<String, String> attributes;
    private TSApplication tsApplication;

    public CommandExecution(Region region, Task task, Transaction transaction, String distributedUOW, Program program, ResourceAndVerb resourceAndVerb, String tcbMode, String prevTCBMode, Timestamp commandTime, String RESP, String RESP2, Map<String, String> allAttributes) {
        this.region = region;
        this.program = program;
        this.task = task;
        this.distributedUOW = distributedUOW;
        this.commandTime = commandTime;
        this.transaction = transaction;
        this.tcbMode = tcbMode;
        this.prevTCBMode = prevTCBMode;
        this.resourceAndVerb = resourceAndVerb;
        this.RESP = RESP;
        this.RESP2 = RESP2;
        this.isError = IAUtilities.hasContent(RESP) && !OKRESPONSE.equals(RESP) || IAUtilities.hasContent(RESP) && !OKRESPONSE.equals(RESP2);
        this.attributes = allAttributes;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public String getRESP() {
        return this.RESP;
    }

    public void setRESP(String rESP) {
        this.RESP = rESP;
    }

    public String getRESP2() {
        return this.RESP2;
    }

    public void setRESP2(String rESP2) {
        this.RESP2 = rESP2;
    }

    public void setCommandTime(Timestamp commandTime) {
        this.commandTime = commandTime;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public void setResourceAndVerb(ResourceAndVerb resourceAndVerb) {
        this.resourceAndVerb = resourceAndVerb;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public Task getTask() {
        return this.task;
    }

    public Timestamp getCommandTime() {
        return this.commandTime;
    }

    public String getDistributedUOW() {
        return this.distributedUOW;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.task.getTaskID());
        buffer.append(' ');
        buffer.append(this.transaction);
        buffer.append(' ');
        buffer.append(this.program);
        buffer.append(' ');
        buffer.append(this.distributedUOW);
        buffer.append(' ');
        buffer.append(this.resourceAndVerb.getVerb());
        buffer.append(' ');
        buffer.append(this.resourceAndVerb.getType());
        buffer.append(' ');
        buffer.append(this.resourceAndVerb.getName());
        buffer.append(' ');
        buffer.append(this.commandTime);
        return buffer.toString();
    }

    public Program getProgram() {
        return this.program;
    }

    public String getAsCopyString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.region.getName());
        buffer.append(',');
        buffer.append(this.transaction.getName());
        buffer.append(',');
        buffer.append(this.task.getName());
        buffer.append(',');
        buffer.append(this.distributedUOW);
        buffer.append(',');
        buffer.append(this.program.getName());
        buffer.append(',');
        buffer.append(this.resourceAndVerb.getVerb());
        buffer.append(' ');
        buffer.append(this.resourceAndVerb.getType());
        buffer.append(',');
        buffer.append(this.resourceAndVerb.getName());
        buffer.append(',');
        buffer.append(this.commandTime);
        return buffer.toString();
    }

    public String getTCBMode() {
        return this.tcbMode;
    }

    public String getPrevTCBMode() {
        return this.prevTCBMode;
    }

    public static Map<String, List<ResourceAndVerb>> getTargetsByTCBMode(Collection<CommandExecution> interactions) {
        Debug.enter((Logger)logger, (String)CommandExecution.class.getName(), (String)"getTargetsByTCBMode", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "interactions size(): " + interactions.size()});
        HashMap<String, List<ResourceAndVerb>> map = new HashMap<String, List<ResourceAndVerb>>();
        for (CommandExecution commandExecution : interactions) {
            String mode = commandExecution.getTCBMode();
            ArrayList<ResourceAndVerb> list = (ArrayList<ResourceAndVerb>)map.get(mode);
            if (list == null) {
                list = new ArrayList<ResourceAndVerb>();
                map.put(mode, list);
            }
            ResourceAndVerb resourceAndVerb = commandExecution.getResourceAndVerb();
            list.add(resourceAndVerb);
        }
        Debug.exit((Logger)logger, (String)CommandExecution.class.getName(), (String)"getTargetsByTCBMode", (Object)("map size: " + map.size()));
        return map;
    }

    public ResourceAndVerb getResourceAndVerb() {
        return this.resourceAndVerb;
    }

    public static HashMap<String, Map<String, List<ResourceAndVerb>>> getTargetsByTCBModeSwap(Collection<CommandExecution> interactions) {
        Debug.enter((Logger)logger, (String)CommandExecution.class.getName(), (String)"getTargetsByTCBModeSwap", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "interactions size: " + interactions.size()});
        HashMap<String, Map<String, List<ResourceAndVerb>>> swaps = new HashMap<String, Map<String, List<ResourceAndVerb>>>();
        for (CommandExecution commandExecution : interactions) {
            List<ResourceAndVerb> resourcesAndVerbs;
            String mode = commandExecution.getTCBMode();
            String prevTCBMode = commandExecution.getPrevTCBMode();
            ResourceAndVerb resourceAndVerb = commandExecution.getResourceAndVerb();
            if (mode.equals(prevTCBMode)) continue;
            Map<String, List<ResourceAndVerb>> tCBModeToResource = swaps.get(prevTCBMode);
            if (tCBModeToResource == null) {
                tCBModeToResource = new HashMap<String, List<ResourceAndVerb>>();
                swaps.put(prevTCBMode, tCBModeToResource);
            }
            if ((resourcesAndVerbs = tCBModeToResource.get(mode)) == null) {
                resourcesAndVerbs = new ArrayList<ResourceAndVerb>();
                tCBModeToResource.put(mode, resourcesAndVerbs);
            }
            resourcesAndVerbs.add(resourceAndVerb);
        }
        Debug.exit((Logger)logger, (String)CommandExecution.class.getName(), (String)"getTargetsByTCBModeSwap", (Object)("swaps size: " + swaps.size()));
        return swaps;
    }

    public boolean isError() {
        return this.isError;
    }

    public String getErrors() {
        return "RESP=" + Integer.parseInt(this.RESP, 16) + " RESP2=" + Integer.parseInt(this.RESP2, 16);
    }

    public String get(String column) {
        return this.attributes.get(column);
    }

    public void setTSApplication(TSApplication tsApplication) {
        this.tsApplication = tsApplication;
    }

    public TSApplication getTSApplication() {
        return this.tsApplication;
    }
}

