/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.CICSResource;
import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModelBaseImpl;
import com.ibm.cics.ia.model.IMSResource;
import com.ibm.cics.ia.model.MQResource;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPEPS;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CiuspepsEntryPointsModel
extends EntryPointsModelBaseImpl {
    private static final Logger logger = Logger.getLogger(CiuspepsEntryPointsModel.class.getPackage().getName());

    public CiuspepsEntryPointsModel(Resource resource) {
        this.resource = resource;
    }

    @Override
    public List<EntryPoint> getFreshEntryPoints() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getFreshEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        final ArrayList entryPoints = new ArrayList();
        final String taskName = Messages.getString("Task.retrieveEntryPoints");
        Job job = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"CiuspepsEntryPointsModel.getFreshEntryPoints().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                StoredProcedureCommand command = new StoredProcedureCommand(){
                    private SelectionObject selectionObject;

                    public Object processRow(ResultSet rs) throws SQLException {
                        ResultSetMetaData metaData = rs.getMetaData();
                        EntryPoint entryPoint = null;
                        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                        switch (CiuspepsEntryPointsModel.this.getCallTypeParam()) {
                            case T: 
                            case P: {
                                int i = 1;
                                while (i <= 8) {
                                    additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                    ++i;
                                }
                                entryPoint = new EntryPoint(rs.getString(9).trim(), String.valueOf(rs.getString(9).trim()) + "_OPER", BundleTypeHelper.BundlePartType.TRANSACTION, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(9));
                                entryPoint = new EntryPoint(rs.getString(10).trim(), String.valueOf(rs.getString(10).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(10));
                                entryPoint = new EntryPoint(rs.getString(11).trim(), String.valueOf(rs.getString(11).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(11));
                                break;
                            }
                            case U: {
                                int i = 1;
                                while (i <= 9) {
                                    additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                    ++i;
                                }
                                entryPoint = new EntryPoint(rs.getString(10).trim(), String.valueOf(rs.getString(10).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(10));
                                entryPoint = new EntryPoint(rs.getString(11).trim(), String.valueOf(rs.getString(11).trim()) + "_OPER", BundleTypeHelper.BundlePartType.URIMAP, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(11));
                                entryPoint = new EntryPoint(rs.getString(12).trim(), String.valueOf(rs.getString(12).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(12));
                            }
                        }
                        return entryPoints;
                    }

                    public SelectionObject getSelectionObject() {
                        String callType = CiuspepsEntryPointsModel.this.getCallTypeParam().name();
                        String collectionId = IASQLCommand.getCollectionId().isEmpty() ? "%" : IASQLCommand.getCollectionId();
                        String applid = CiuspepsEntryPointsModel.this.getRegionParam() != null ? CiuspepsEntryPointsModel.this.getRegionParam() : "%";
                        String object = ((Resource)(this).CiuspepsEntryPointsModel.this.resource).getName();
                        CiuspepsEntryPointsModel.this.setObjectType1Param(ResourceFilter.CICS);
                        CiuspepsEntryPointsModel.this.setObjectType2Param(((Resource)(this).CiuspepsEntryPointsModel.this.resource).getTypeName());
                        if ((this).CiuspepsEntryPointsModel.this.resource instanceof CICSResource) {
                            CiuspepsEntryPointsModel.this.setObjectType1Param(ResourceFilter.CICS);
                        } else if ((this).CiuspepsEntryPointsModel.this.resource instanceof DB2Resource) {
                            CiuspepsEntryPointsModel.this.setObjectType1Param(ResourceFilter.DB2);
                        } else if ((this).CiuspepsEntryPointsModel.this.resource instanceof IMSResource) {
                            CiuspepsEntryPointsModel.this.setObjectType1Param(ResourceFilter.IMS);
                        } else if ((this).CiuspepsEntryPointsModel.this.resource instanceof MQResource) {
                            CiuspepsEntryPointsModel.this.setObjectType1Param(ResourceFilter.MQ);
                        }
                        return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPEPS().getSelectionObject(callType, collectionId, applid, object, CiuspepsEntryPointsModel.this.getObjectType1Param(), CiuspepsEntryPointsModel.this.getObjectType2Param())) : this.selectionObject;
                    }
                };
                command.setCategory("com.ibm.cics.ia.connection.db2");
                command.setAsync(false);
                command.start();
                List results = command.getResults();
                CiuspepsEntryPointsModel.this.entryPoints.clear();
                for (Object result : results) {
                    List entryPoints2 = (List)result;
                    CiuspepsEntryPointsModel.this.entryPoints.addAll(entryPoints2);
                }
                CiuspepsEntryPointsModel.this.entryPoints = new ArrayList(new LinkedHashSet(CiuspepsEntryPointsModel.this.entryPoints));
                CiuspepsEntryPointsModel.this.enableEntryPointsBasedOnCicsTsLevel();
                Debug.exit((Logger)logger, (String)"CiuspepsEntryPointsModel.getFreshEntryPoints().ProgressMonitorDialog", (String)"run");
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"run", (Throwable)e, new HashMap());
            IAPlugin.getDefault().logError("Unable to get entry points", e);
        }
        return this.entryPoints;
    }
}

