/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModel;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPEP3;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class Ciuspep3StoredProcedureCommand
extends StoredProcedureCommand {
    private SelectionObject selectionObject;
    private Object resource;
    final List<EntryPoint> entryPoints = new ArrayList<EntryPoint>();

    public Ciuspep3StoredProcedureCommand(Object resource) {
        this.resource = resource;
    }

    public Object processRow(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        EntryPoint entryPoint = null;
        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
        if (metaData.getColumnCount() == 11) {
            int i = 1;
            while (i <= 8) {
                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                ++i;
            }
            entryPoint = new EntryPoint(rs.getString(9).trim(), String.valueOf(rs.getString(9).trim()) + "_OPER", BundleTypeHelper.BundlePartType.TRANSACTION, additionalAttributes);
            this.entryPoints.add(entryPoint);
            entryPoint.setUserFriendlyType(metaData.getColumnName(9));
            entryPoint = new EntryPoint(rs.getString(10).trim(), String.valueOf(rs.getString(10).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
            this.entryPoints.add(entryPoint);
            entryPoint.setUserFriendlyType(metaData.getColumnName(10));
            entryPoint = new EntryPoint(rs.getString(11).trim(), String.valueOf(rs.getString(11).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
            this.entryPoints.add(entryPoint);
            entryPoint.setUserFriendlyType(metaData.getColumnName(11));
        } else {
            int i = 1;
            while (i <= 9) {
                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                ++i;
            }
            entryPoint = new EntryPoint(rs.getString(10).trim(), String.valueOf(rs.getString(10).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
            this.entryPoints.add(entryPoint);
            entryPoint.setUserFriendlyType(metaData.getColumnName(10));
            entryPoint = new EntryPoint(rs.getString(11).trim(), String.valueOf(rs.getString(11).trim()) + "_OPER", BundleTypeHelper.BundlePartType.URIMAP, additionalAttributes);
            this.entryPoints.add(entryPoint);
            entryPoint.setUserFriendlyType(metaData.getColumnName(11));
            entryPoint = new EntryPoint(rs.getString(12).trim(), String.valueOf(rs.getString(12).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
            this.entryPoints.add(entryPoint);
            entryPoint.setUserFriendlyType(metaData.getColumnName(12));
        }
        return this.entryPoints;
    }

    public SelectionObject getSelectionObject() {
        String IN_CALLTYPE = "";
        String IN_PLATFORM = "";
        String IN_APPLNAME = "";
        int IN_APPLVER1 = 0;
        int IN_APPLVER2 = 0;
        int IN_APPLVER3 = 0;
        String IN_APPLOPER = "";
        if (this.resource instanceof Platform) {
            IN_CALLTYPE = EntryPointsModel.CallType.P.name();
            IN_PLATFORM = ((Platform)this.resource).getName();
        } else if (this.resource instanceof TSApplication) {
            IN_CALLTYPE = EntryPointsModel.CallType.A.name();
            TSApplication application = (TSApplication)this.resource;
            Platform platform = application.getPlatform();
            if (platform != null) {
                IN_PLATFORM = platform.getName();
            }
            IN_APPLNAME = application.getName();
            IN_APPLVER1 = application.getMajorVersion();
            IN_APPLVER2 = application.getMinorVersion();
            IN_APPLVER3 = application.getMicroVersion();
        } else if (this.resource instanceof Operation) {
            IN_CALLTYPE = EntryPointsModel.CallType.O.name();
            Operation operation = (Operation)this.resource;
            TSApplication application = operation.getApplication();
            if (application != null) {
                Platform platform = application.getPlatform();
                if (platform != null) {
                    IN_PLATFORM = platform.getName();
                }
                IN_APPLNAME = application.getName();
                IN_APPLVER1 = application.getMajorVersion();
                IN_APPLVER2 = application.getMinorVersion();
                IN_APPLVER3 = application.getMicroVersion();
            }
            IN_APPLOPER = operation.getName();
        }
        String IN_COLLID = IASQLCommand.getCollectionId().isEmpty() ? "%" : IASQLCommand.getCollectionId();
        return this.getSelectionObject(IN_CALLTYPE, IN_COLLID, IN_PLATFORM, IN_APPLNAME, IN_APPLVER1, IN_APPLVER2, IN_APPLVER3, IN_APPLOPER);
    }

    public SelectionObject getSelectionObject(String IN_CALLTYPE, String IN_COLLID, String IN_PLATFORM, String IN_APPLNAME, int IN_APPLVER1, int IN_APPLVER2, int IN_APPLVER3, String IN_APPLOPER) {
        return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPEP3().getSelectionObject(IN_CALLTYPE, IN_COLLID, IN_PLATFORM, IN_APPLNAME, IN_APPLVER1, IN_APPLVER2, IN_APPLVER3, IN_APPLOPER)) : this.selectionObject;
    }
}

