/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Ciuspep3StoredProcedureCommand;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModelBaseImpl;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.runtime.IAPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class Ciuspep3EntryPointsModel
extends EntryPointsModelBaseImpl {
    private static final Logger logger = Logger.getLogger(Ciuspep3EntryPointsModel.class.getPackage().getName());

    public Ciuspep3EntryPointsModel(Object resource) {
        this.resource = resource;
    }

    @Override
    public List<EntryPoint> getFreshEntryPoints() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getFreshEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        final String taskName = Messages.getString("Task.retrieveEntryPoints");
        Job job = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"Ciuspep3EntryPointsModel.getFreshEntryPoints().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                Ciuspep3StoredProcedureCommand command = new Ciuspep3StoredProcedureCommand(Ciuspep3EntryPointsModel.this.resource);
                command.setCategory("com.ibm.cics.ia.connection.db2");
                command.setAsync(false);
                command.start();
                List results = command.getResults();
                Ciuspep3EntryPointsModel.this.entryPoints.clear();
                for (Object result : results) {
                    List entryPoints = (List)result;
                    Ciuspep3EntryPointsModel.this.entryPoints.addAll(entryPoints);
                }
                Ciuspep3EntryPointsModel.this.entryPoints = new ArrayList(new LinkedHashSet(Ciuspep3EntryPointsModel.this.entryPoints));
                Ciuspep3EntryPointsModel.this.enableEntryPointsBasedOnCicsTsLevel();
                Debug.exit((Logger)logger, (String)"Ciuspep3EntryPointsModel.getFreshEntryPoints().ProgressMonitorDialog", (String)"run");
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"run", (Throwable)e, new HashMap());
            IAPlugin.getDefault().logError("Unable to get entry points", e);
        }
        return this.entryPoints;
    }
}

