/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CintCollectorPropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CintCollectorPropertySource.class.getPackage().getName());
    private CintCollector cintCollector;
    private IPropertyDescriptor[] propertyDescriptors;
    private Map values = new HashMap();
    public static String[] propertyIDs = new String[]{"applid", "sysid", "state", "datestart", "timestart", "collect", "datesave", "timesave", "datechange", "timechange", "pauses", "saves", "recslastsave", "recstotal", "runtimetotal", "pausedtotal", "dspacename", "dspacefull"};

    public CintCollectorPropertySource(CintCollector collector) {
        this.cintCollector = collector;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)CintCollectorPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null) {
            HashMap properties = this.cintCollector.getProperties();
            if (properties == null) {
                properties = new HashMap();
            }
            if (properties.size() > 0) {
                this.getValues(properties);
            } else {
                this.values = new HashMap();
                this.propertyDescriptors = new IPropertyDescriptor[0];
            }
        }
        Debug.exit((Logger)logger, (String)CintCollectorPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.propertyDescriptors;
    }

    private void getValues(Map properties) {
        Debug.enter((Logger)logger, (String)CintCollectorPropertySource.class.getName(), (String)"getValues", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.propertyDescriptors = new IPropertyDescriptor[propertyIDs.length];
        Map m = properties;
        int j = 0;
        while (j < propertyIDs.length) {
            String key = propertyIDs[j];
            String newKey = String.valueOf(key) + m.get("applid");
            this.values.put(newKey, m.get(key));
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
            descriptor.setCategory(Messages.getString("CintCollectorPropertySource.0"));
            this.propertyDescriptors[j] = descriptor;
            ++j;
        }
        Debug.exit((Logger)logger, (String)CintCollectorPropertySource.class.getName(), (String)"getValues");
    }

    public Object getPropertyValue(Object id) {
        return this.values.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

