/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CincCollectorPropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CincCollectorPropertySource.class.getPackage().getName());
    private CincCollector cincCollector;
    private IPropertyDescriptor[] propertyDescriptors;
    private Map values = new HashMap();

    public CincCollectorPropertySource(CincCollector collector) {
        this.cincCollector = collector;
        this.values = collector.getProperties();
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)CincCollectorPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null) {
            HashMap properties = this.cincCollector.getProperties();
            if (properties == null) {
                properties = new HashMap();
            }
            if (properties.size() > 0) {
                this.getValues(properties);
            } else {
                this.values = new HashMap();
                this.propertyDescriptors = new IPropertyDescriptor[0];
            }
        }
        Debug.exit((Logger)logger, (String)CincCollectorPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.propertyDescriptors;
    }

    private void getValues(Map properties) {
        PropertyDescriptor descriptor;
        String newKey;
        String value;
        Set keySet;
        Debug.enter((Logger)logger, (String)CincCollectorPropertySource.class.getName(), (String)"getValues", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Map m = properties;
        Map detailsMap = (Map)m.get("details");
        Map regionMap = (Map)m.get("cincstate");
        Map applidMap = (Map)m.get("applid");
        int size = detailsMap != null ? detailsMap.size() : 0;
        size += applidMap != null ? applidMap.size() : 0;
        this.propertyDescriptors = new IPropertyDescriptor[size += regionMap != null ? regionMap.size() * 4 : 0];
        int i = 0;
        if (detailsMap != null) {
            keySet = detailsMap.keySet();
            for (String key : keySet) {
                value = (String)detailsMap.get(key);
                newKey = String.valueOf(key) + value;
                this.values.put(newKey, value);
                descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
                descriptor.setCategory(Messages.getString("CincCollectorPropertySource.0"));
                this.propertyDescriptors[i] = descriptor;
                ++i;
            }
        }
        if (applidMap != null) {
            keySet = applidMap.keySet();
            for (String key : keySet) {
                value = (String)applidMap.get(key);
                if (key.length() == 1) {
                    key = "0" + key;
                }
                newKey = String.valueOf(key) + value;
                this.values.put(newKey, value);
                descriptor = new PropertyDescriptor((Object)newKey, String.valueOf(Messages.getString("applid")) + " " + key);
                descriptor.setCategory(Messages.getString("CincCollectorPropertySource.1"));
                this.propertyDescriptors[i] = descriptor;
                ++i;
            }
        }
        if (regionMap != null) {
            keySet = regionMap.keySet();
            for (String number : keySet) {
                String key;
                String[] cf_values = (String[])regionMap.get(number);
                key = "applid" + number;
                value = cf_values[0];
                newKey = String.valueOf(key) + value;
                this.values.put(newKey, value);
                descriptor = new PropertyDescriptor((Object)newKey, Messages.getString("applid"));
                descriptor.setCategory(Messages.getString("applid" + number));
                this.propertyDescriptors[i] = descriptor;
                ++i;
                key = "sysid" + number;
                value = cf_values[1];
                newKey = String.valueOf(key) + value;
                this.values.put(newKey, value);
                descriptor = new PropertyDescriptor((Object)newKey, Messages.getString("sysid"));
                descriptor.setCategory(Messages.getString("applid" + number));
                this.propertyDescriptors[i] = descriptor;
                ++i;
                key = "cf_total";
                value = cf_values[2];
                newKey = "applid" + number + key + value;
                this.values.put(newKey, value);
                descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
                descriptor.setCategory(Messages.getString("applid" + number));
                this.propertyDescriptors[i] = descriptor;
                ++i;
                key = "curr_state";
                value = cf_values[3];
                newKey = "applid" + number + key + value;
                this.values.put(newKey, value);
                descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
                descriptor.setCategory(Messages.getString("applid" + number));
                this.propertyDescriptors[i] = descriptor;
                ++i;
            }
        }
        Debug.exit((Logger)logger, (String)CincCollectorPropertySource.class.getName(), (String)"getValues");
    }

    public Object getPropertyValue(Object id) {
        return this.values.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

