/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CallAnalyzer
extends Command {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CallAnalyzer.class.getPackage().getName());
    private Resource root;
    private ArrayList listeners;
    private Region region;
    private boolean collectPrograms;
    private boolean collectTransactions;
    private LinkedList queue;
    private ArrayList<Resource> completedResources = new ArrayList();

    public CallAnalyzer(boolean programs, boolean transactions) {
        Debug.enter((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"CallAnalyzer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.collectPrograms = programs;
        this.collectTransactions = transactions;
        if (!programs && !transactions) {
            throw new RuntimeException("To show where a resoure is used either transactions or programs, or both, must be specified");
        }
        Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"CallAnalyzer");
    }

    public void addListener(Listener aListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(aListener);
    }

    public void removeListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public void setRoot(Resource aRoot) {
        this.root = aRoot;
    }

    public void start() {
        Debug.enter((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IAPlugin.getDefault().isCommandLoggingActive()) {
            IAPlugin.getDefault().logInformation(">Used By: " + this.getDescription());
        }
        if (this.status == 1) {
            Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"start");
            return;
        }
        this.status = 0;
        ArrayList recursionList = new ArrayList();
        this.addSourceInteractionsFor(this.root, recursionList, 0);
        List copyOfListeners = (List)this.listeners.clone();
        for (Listener listener : copyOfListeners) {
            listener.completed();
        }
        if (this.status != 4) {
            this.status = 1;
        }
        this.clear();
        IAPlugin.getDefault().taskEnded();
        Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"start");
    }

    private void addSourceInteractionsFor(Resource resource, List recursionList, int depth) {
        Debug.enter((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.queue = new LinkedList();
        this.queue.addLast(resource);
        while (!this.queue.isEmpty()) {
            resource = (Resource)this.queue.removeFirst();
            if (this.status == 4) {
                return;
            }
            if (recursionList.contains(resource)) continue;
            List sourceInteractions = null;
            if (this.collectPrograms) {
                sourceInteractions = resource.getSourceProgramInteractions();
            } else if (this.collectTransactions) {
                sourceInteractions = resource.getSourceTransactionInteractions();
            }
            if (sourceInteractions == null) {
                this.status = 4;
                Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor");
                return;
            }
            if (this.region != null && sourceInteractions != null) {
                sourceInteractions = Interaction.filterByRegion(sourceInteractions, this.region);
            }
            recursionList.add(resource);
            if (this.status == 4) {
                Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor");
                return;
            }
            Map sourcesAndVerbsByType = Interaction.getSourcesAndVerbsByType(sourceInteractions);
            Map sourcesAndVerbs = null;
            if (this.collectPrograms) {
                sourcesAndVerbs = (Map)sourcesAndVerbsByType.get("PROGRAM");
            } else if (this.collectTransactions) {
                sourcesAndVerbs = (Map)sourcesAndVerbsByType.get("TRANSID");
            }
            if (sourcesAndVerbs != null) {
                Iterator entrySet = sourcesAndVerbs.entrySet().iterator();
                while (entrySet.hasNext()) {
                    if (this.status == 4) {
                        Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor");
                        return;
                    }
                    Map.Entry sourceAndVerbs = entrySet.next();
                    Resource source = (Resource)sourceAndVerbs.getKey();
                    List verbs = (List)sourceAndVerbs.getValue();
                    verbs = IAUtilities.asUniqueCollection(verbs);
                    if (this.listeners == null) continue;
                    List copyOfListeners = (List)this.listeners.clone();
                    Iterator iter = copyOfListeners.iterator();
                    while (iter.hasNext()) {
                        if (this.status == 4) {
                            Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor");
                            return;
                        }
                        Listener listener = (Listener)iter.next();
                        ResourceAnalysis resourceAnalysis = new ResourceAnalysis(resource, source, verbs, depth);
                        listener.resourceAnalyzed(resourceAnalysis);
                        this.getResults().add(resourceAnalysis);
                    }
                }
            }
            ArrayList<Resource> callingObjects = new ArrayList<Resource>();
            Iterator iter = sourceInteractions.iterator();
            while (iter.hasNext()) {
                if (this.status == 4) {
                    Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor");
                    return;
                }
                Interaction interaction = (Interaction)iter.next();
                Resource source = interaction.getSource();
                callingObjects.add(source);
            }
            iter = callingObjects.iterator();
            while (iter.hasNext()) {
                if (this.status == 4) {
                    Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"addSourceInteractionsFor");
                    return;
                }
                Resource callingObject = (Resource)iter.next();
                this.queue.addLast(callingObject);
            }
            ++depth;
        }
        this.completedResources.add(resource);
    }

    public void setRegion(Region aRegion) {
        this.region = aRegion;
    }

    public Resource getRoot() {
        return this.root;
    }

    public Region getRegion() {
        return this.region;
    }

    public void reset(Resource resource, Region aRegion, boolean collectProgs, boolean collectTrans) {
        Debug.enter((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"reset", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.status = -1;
        this.setRegion(this.region);
        this.setRoot(resource);
        this.collectPrograms = collectProgs;
        this.collectTransactions = collectTrans;
        Debug.exit((Logger)logger, (String)CallAnalyzer.class.getName(), (String)"reset");
    }

    public void clear() {
        if (this.queue != null) {
            this.queue.clear();
        }
        for (Resource completedResource : this.completedResources) {
            completedResource.clearSourceInteractions();
            completedResource.clearTargetInteractions();
        }
        this.completedResources.clear();
    }

    public void cancel() {
        this.clear();
        super.cancel();
    }

    public static interface Listener {
        public void resourceAnalyzed(ResourceAnalysis var1);

        public void itemsAdded(Collection var1);

        public void completed();
    }

    public static class ResourceAnalysis {
        private static final Logger logger = Logger.getLogger(ResourceAnalysis.class.getPackage().getName());
        public Resource target;
        public Resource source;
        public List verbs;
        public int depth;

        public ResourceAnalysis(Resource aTarget, Resource aSource, List verbs, int depth) {
            this.target = aTarget;
            this.source = aSource;
            this.verbs = verbs;
            this.depth = depth;
        }
    }
}

