/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityLifetime;
import com.ibm.cics.ia.model.AffinityRelation;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuiltAffGroup
implements IAffinityBuilderInputGroup {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(BuiltAffGroup.class.getPackage().getName());
    public static final String XML_AFFINITY_GROUP = "AffinityGroup";
    public static final String XML_DERIVED_FROM = "DerivedFrom";
    public static final String XML_FILE = "File";
    public static final String XML_GROUP = "Group";
    public static final String XML_TRANSACTIONS = "Transactions";
    public static final String XML_TRANSACTION = "Transaction";
    public static final String XML_NAME = "Name";
    public static final String XML_CREATE = "Create";
    public static final String XML_REMOVE = "Remove";
    public static final String XML_MATCH = "Match";
    public static final String XML_STATE = "State";
    private String tranGroup;
    private Set<Transaction> transactions;
    private AffinityRelation relation;
    private AffinityLifetime lifetime;
    private String match;
    private String state;
    private HashMap<String, List<String>> derivedFrom;
    private boolean doRemove;
    private boolean doCreate;
    private HashMap<Transaction, Boolean> doTransactions;

    @Override
    public void persist(Document doc, Element parent) {
        Debug.enter((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"persist", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "doc: " + (doc == null ? doc : doc.getLocalName()), "parent: " + (parent == null ? parent : parent.getLocalName())});
        Element element = doc.createElement(XML_AFFINITY_GROUP);
        if (parent != null) {
            parent.appendChild(element);
        } else {
            doc.appendChild(element);
        }
        element.setAttribute(XML_NAME, this.tranGroup);
        element.setAttribute("AFFINITY", this.relation.toString());
        element.setAttribute("LIFETIME", this.lifetime.toString());
        element.setAttribute(XML_MATCH, this.match);
        element.setAttribute(XML_STATE, this.state);
        element.setAttribute(XML_CREATE, Boolean.toString(this.doCreate));
        element.setAttribute(XML_REMOVE, Boolean.toString(this.doRemove));
        Element derivedFromElement = doc.createElement(XML_DERIVED_FROM);
        element.appendChild(derivedFromElement);
        for (Map.Entry<String, List<String>> entry : this.derivedFrom.entrySet()) {
            Element fileElement = doc.createElement(XML_FILE);
            derivedFromElement.appendChild(fileElement);
            fileElement.setAttribute(XML_NAME, entry.getKey());
            derivedFromElement.appendChild(fileElement);
            for (String string : entry.getValue()) {
                Element groupElement = doc.createElement(XML_GROUP);
                fileElement.appendChild(groupElement);
                groupElement.setTextContent(string);
            }
        }
        Element transactionsElement = doc.createElement(XML_TRANSACTIONS);
        element.appendChild(transactionsElement);
        for (Transaction transaction : this.transactions) {
            Element transactionElement = doc.createElement(XML_TRANSACTION);
            transactionsElement.appendChild(transactionElement);
            transactionElement.setAttribute(XML_NAME, transaction.getName());
            transactionElement.setAttribute(XML_CREATE, this.doTransactions.get(transaction).toString());
        }
        Debug.exit((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"persist", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public static BuiltAffGroup parseDOM(Element item) {
        String doRemoveString;
        Debug.enter((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"parseDOM", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "item: " + (item == null ? item : item.getLocalName())});
        NamedNodeMap attributesMap = item.getAttributes();
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 0;
        while (i < attributesMap.getLength()) {
            Node node = attributesMap.item(i);
            properties.put(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        String tranGroup = (String)properties.get(XML_NAME);
        String relation = (String)properties.get("AFFINITY");
        String lifetime = (String)properties.get("LIFETIME");
        String match = (String)properties.get(XML_MATCH);
        String state = (String)properties.get(XML_STATE);
        Boolean createGroup = true;
        Boolean removeGroup = false;
        String doCreateString = item.getAttribute(XML_CREATE);
        if (IAUtilities.hasContent(doCreateString)) {
            createGroup = Boolean.valueOf(doCreateString);
        }
        if (IAUtilities.hasContent(doRemoveString = item.getAttribute(XML_REMOVE))) {
            removeGroup = Boolean.valueOf(doRemoveString);
        }
        HashMap derivedFrom = new HashMap();
        HashSet<Transaction> transactions = new HashSet<Transaction>();
        HashMap<Transaction, Boolean> doTransactions = new HashMap<Transaction, Boolean>();
        NodeList list = item.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            if (list.item(i2) instanceof Element) {
                Element item3;
                int j;
                NodeList list2;
                Element item2 = (Element)list.item(i2);
                if (item2.getNodeName().equals(XML_DERIVED_FROM)) {
                    list2 = item2.getChildNodes();
                    j = 0;
                    while (j < list2.getLength()) {
                        if (list2.item(j) instanceof Element && (item3 = (Element)list2.item(j)).getNodeName().equals(XML_FILE)) {
                            String fileName = item3.getAttribute(XML_NAME);
                            ArrayList<String> groupDescriptions = new ArrayList<String>();
                            derivedFrom.put(fileName, groupDescriptions);
                            NodeList list3 = item3.getChildNodes();
                            int k = 0;
                            while (k < list3.getLength()) {
                                Element item4;
                                if (list3.item(k) instanceof Element && (item4 = (Element)list3.item(k)).getNodeName().equals(XML_GROUP)) {
                                    String groupText = item4.getTextContent();
                                    groupDescriptions.add(groupText);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                } else if (item2.getNodeName().equals(XML_TRANSACTIONS)) {
                    list2 = item2.getChildNodes();
                    j = 0;
                    while (j < list2.getLength()) {
                        if (list2.item(j) instanceof Element && (item3 = (Element)list2.item(j)).getNodeName().equals(XML_TRANSACTION)) {
                            String transactionName = item3.getAttribute(XML_NAME);
                            doCreateString = item3.getAttribute(XML_CREATE);
                            Boolean createTransaction = true;
                            if (IAUtilities.hasContent(doCreateString)) {
                                createTransaction = Boolean.valueOf(doCreateString);
                            }
                            Transaction transaction = ResourceFactory.getSingleton().getTransaction(transactionName);
                            transactions.add(transaction);
                            doTransactions.put(transaction, createTransaction);
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        if (IAUtilities.hasContent(tranGroup) && derivedFrom.size() > 0 && transactions.size() > 0) {
            BuiltAffGroup affGroup = new BuiltAffGroup(tranGroup);
            affGroup.derivedFrom = derivedFrom;
            affGroup.lifetime = AffinityLifetime.valueOf(lifetime);
            affGroup.match = match;
            affGroup.relation = AffinityRelation.valueOf(relation);
            affGroup.state = state;
            affGroup.transactions = transactions;
            affGroup.doTransactions = doTransactions;
            affGroup.doCreate = createGroup;
            affGroup.doRemove = removeGroup;
            Debug.exit((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "affGroup: " + affGroup.toString()});
            return affGroup;
        }
        Debug.exit((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "return null"});
        return null;
    }

    public BuiltAffGroup(String aTranGroup) {
        Debug.enter((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"AffGroup", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aTranGroup: " + aTranGroup});
        this.tranGroup = aTranGroup;
        Debug.exit((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"AffGroup");
    }

    @Override
    public String getTranGroup() {
        return this.tranGroup;
    }

    @Override
    public void setTranGroup(String tranGroup) {
        this.tranGroup = tranGroup;
    }

    @Override
    public AffinityRelation getAffinity() {
        return this.relation;
    }

    @Override
    public void setAffinity(AffinityRelation affinity) {
        this.relation = affinity;
    }

    @Override
    public AffinityLifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(AffinityLifetime lifetime) {
        this.lifetime = lifetime;
    }

    public HashMap<String, List<String>> getDerivedFrom() {
        return this.derivedFrom;
    }

    public void setDerivedFrom(HashMap<String, List<String>> derivedFrom) {
        this.derivedFrom = derivedFrom;
    }

    @Override
    public Set<Transaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public void setTransactions(Set<Transaction> transactions) {
        Debug.enter((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"setTransactions", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "transactions size: " + transactions.size()});
        this.transactions = transactions;
        this.doTransactions = new HashMap();
        for (Transaction transaction : transactions) {
            this.doTransactions.put(transaction, true);
        }
        Debug.exit((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"setTransactions", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isDoRemove() {
        return this.doRemove;
    }

    public void setDoRemove(boolean doRemove) {
        this.doRemove = doRemove;
    }

    public boolean isDoCreate() {
        return this.doCreate;
    }

    public void setDoCreate(boolean doCreate) {
        this.doCreate = doCreate;
    }

    public Boolean getCreateTransaction(Transaction transaction) {
        return this.doTransactions.get(transaction);
    }

    public void setCreateTransaction(Transaction transaction, Boolean create) {
        this.doTransactions.put(transaction, create);
    }

    public void addTransaction(Transaction transaction, Boolean create) {
        this.transactions.add(transaction);
        this.doTransactions.put(transaction, create);
    }

    public void removeTransaction(Transaction transaction) {
        this.transactions.remove(transaction);
        this.doTransactions.remove(transaction);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.derivedFrom == null ? 0 : this.derivedFrom.hashCode());
        result = 31 * result + (this.doCreate ? 1231 : 1237);
        result = 31 * result + (this.doRemove ? 1231 : 1237);
        result = 31 * result + (this.lifetime == null ? 0 : this.lifetime.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.tranGroup == null ? 0 : this.tranGroup.hashCode());
        result = 31 * result + (this.transactions == null ? 0 : this.transactions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuiltAffGroup other = (BuiltAffGroup)obj;
        if (this.derivedFrom == null ? other.derivedFrom != null : !this.derivedFrom.equals(other.derivedFrom)) {
            return false;
        }
        if (this.doCreate != other.doCreate) {
            return false;
        }
        if (this.doRemove != other.doRemove) {
            return false;
        }
        if (this.lifetime != other.lifetime) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.relation != other.relation) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.tranGroup == null ? other.tranGroup != null : !this.tranGroup.equals(other.tranGroup)) {
            return false;
        }
        return !(this.transactions == null ? other.transactions != null : !this.transactions.equals(other.transactions));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.doRemove) {
            sb.append("REMOVE TRANGRP NAME(" + this.tranGroup + ");\n");
        }
        if (this.doCreate) {
            sb.append("CREATE TRANGRP NAME(" + this.tranGroup + ") AFFINITY(" + (Object)((Object)this.relation) + ")  AFFLIFE(" + (Object)((Object)this.lifetime) + ") \n AFFAUTO(YES) MATCH(" + this.match + ") STATE(" + this.state + ");\n");
            for (Transaction transaction : this.transactions) {
                if (!this.doTransactions.get(transaction).booleanValue()) continue;
                sb.append("    CREATE DTRINGRP TRANGRP(" + this.tranGroup + ") TRANID(" + transaction.getName() + ");\n");
            }
        }
        return sb.toString();
    }
}

