/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomAuthor;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.model.AtomEntry;
import com.ibm.cics.ia.runtime.IAPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtomFeed {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AtomFeed.class.getPackage().getName());
    private String atomConnection;
    public ArrayList<AtomEntry> atomEntries = new ArrayList();
    public AtomAuthor author;
    public HashMap<String, String> values = new HashMap();

    public AtomFeed() {
        this.author = new AtomAuthor();
    }

    private static String escape(InputStream is) throws IOException {
        String str;
        Debug.enter((Logger)logger, (String)AtomFeed.class.getName(), (String)"escape", (Object)("Thread ID: " + Thread.currentThread().getId()));
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        char[] buffer = new char[1024];
        StringBuilder sb = new StringBuilder();
        int k = 0;
        do {
            if ((k = isr.read(buffer)) <= 0) continue;
            sb.append(buffer, 0, k);
        } while (k > 0);
        isr.close();
        is.close();
        int quotesAndEqualLength = 3;
        int i = 0;
        while (i < AtomDefinitions.ESCAPED_ATTRIBUTES.length) {
            int position = sb.indexOf(String.valueOf(AtomDefinitions.ESCAPED_ATTRIBUTES[i]) + "=\"");
            int totalLength = AtomDefinitions.ESCAPED_ATTRIBUTES[i].length() + AtomDefinitions.ESCAPED_ATTRIBUTES_LENGTH[i] + 3;
            int keyLength = AtomDefinitions.ESCAPED_ATTRIBUTES[i].length() + 3 - 1;
            while (position > 0 && position < sb.length() - totalLength) {
                str = sb.substring(position + keyLength, position + totalLength - 1);
                str = AtomContentElement.escape(str);
                sb.replace(position + keyLength, position + totalLength - 1, str);
                position = sb.indexOf(String.valueOf(AtomDefinitions.ESCAPED_ATTRIBUTES[i]) + "=\"", position + str.length());
            }
            ++i;
        }
        Pattern p = Pattern.compile("<app number=\"..\">........</app>");
        Matcher m = p.matcher(sb.toString());
        int position = 0;
        while (m.find(position)) {
            position = m.start();
            str = sb.substring(position + 17, position + 25);
            str = AtomContentElement.escape(str);
            sb.replace(position + 17, position + 25, str);
            position = position + str.length() + 31 - 8;
            m = p.matcher(sb.toString());
        }
        Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"escape");
        return sb.toString();
    }

    public static AtomFeed parse(InputStream is, String connectionID) {
        Debug.enter((Logger)logger, (String)AtomFeed.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            String str = AtomFeed.escape(is);
            Document dom = builder.parse(new ByteArrayInputStream(str.getBytes("UTF-8")));
            Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"parse");
            return AtomFeed.parse(dom, connectionID);
        }
        catch (Exception ex) {
            IAPlugin.getDefault().logError("Couldn't Parse the Atom Feed", ex);
            Debug.warning((Logger)logger, (String)AtomFeed.class.getName(), (String)"parse", (Throwable)ex, new HashMap());
            Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"parse");
            return null;
        }
    }

    public static AtomFeed parse(Document dom, String connectionID) {
        Debug.enter((Logger)logger, (String)AtomFeed.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomFeed feed = new AtomFeed();
        feed.atomConnection = connectionID;
        Element docElement = dom.getDocumentElement();
        if (docElement.getNodeName() == "feed") {
            NodeList nodeList = docElement.getElementsByTagName("*");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element elem = (Element)nodeList.item(i);
                if (elem.getParentNode() == docElement) {
                    if (elem.getTagName() == "author") {
                        feed.author = AtomAuthor.parse(elem);
                    } else if (elem.getTagName() == "entry") {
                        AtomEntry entry = AtomEntry.parse(elem, connectionID);
                        if (entry.atomContent != null) {
                            feed.atomEntries.add(entry);
                        }
                    } else if (elem.getTagName() == "link") {
                        feed.values.put(elem.getAttribute("rel"), elem.getAttribute("href"));
                    } else {
                        feed.values.put(elem.getTagName(), elem.getTextContent());
                    }
                }
                ++i;
            }
        } else {
            Element elem = dom.getDocumentElement();
            AtomEntry entry = AtomEntry.parse(elem, connectionID);
            if (entry.atomContent != null) {
                feed.atomEntries.add(entry);
            }
        }
        Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"parse");
        return feed;
    }

    public void parseNext(InputStream is) {
        try {
            Debug.enter((Logger)logger, (String)AtomFeed.class.getName(), (String)"parseNext", (Object)("Thread ID: " + Thread.currentThread().getId()));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            String str = AtomFeed.escape(is);
            Document dom = builder.parse(new ByteArrayInputStream(str.getBytes("UTF-8")));
            this.parseNext(dom);
        }
        catch (Exception ex) {
            Debug.warning((Logger)logger, (String)AtomFeed.class.getName(), (String)"parseNext", (Throwable)ex, new HashMap());
            IAPlugin.getDefault().logError("Couldn't Parse the Atom Feed", ex);
        }
        Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"parseNext");
    }

    public void parseNext(Document dom) {
        Debug.enter((Logger)logger, (String)AtomFeed.class.getName(), (String)"parseNext", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Element docElement = dom.getDocumentElement();
        if (docElement.getNodeName() == "feed") {
            NodeList nodeList = docElement.getElementsByTagName("*");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element elem = (Element)nodeList.item(i);
                if (elem.getParentNode() == docElement) {
                    if (elem.getTagName() == "author") {
                        this.author = AtomAuthor.parse(elem);
                    } else if (elem.getTagName() == "entry") {
                        AtomEntry entry = AtomEntry.parse(elem, this.atomConnection);
                        if (entry.atomContent != null) {
                            this.atomEntries.add(entry);
                        }
                    } else if (elem.getTagName() == "link") {
                        this.values.put(elem.getAttribute("rel"), elem.getAttribute("href"));
                    } else {
                        this.values.put(elem.getTagName(), elem.getTextContent());
                    }
                }
                ++i;
            }
        } else {
            Element elem = dom.getDocumentElement();
            AtomEntry entry = AtomEntry.parse(elem, this.atomConnection);
            if (entry.atomContent != null) {
                this.atomEntries.add(entry);
            }
        }
        Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"parseNext");
    }

    public void setConnectionID(String connectionID) {
        Debug.enter((Logger)logger, (String)AtomFeed.class.getName(), (String)"setConnectionID", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.atomConnection = connectionID;
        for (AtomEntry entry : this.atomEntries) {
            entry.setConnectionID(connectionID);
        }
        Debug.exit((Logger)logger, (String)AtomFeed.class.getName(), (String)"setConnectionID");
    }
}

