/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomAuthor;
import com.ibm.cics.ia.model.AtomContent;
import java.util.HashMap;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtomEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AtomEntry.class.getPackage().getName());
    public AtomContent atomContent = null;
    public AtomAuthor author;
    public HashMap<String, String> values = new HashMap();
    private String atomConnection;

    AtomEntry() {
        this.author = new AtomAuthor();
    }

    public void setConnectionID(String connectionID) {
        Debug.enter((Logger)logger, (String)AtomEntry.class.getName(), (String)"setConnectionID", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.atomConnection = connectionID;
        this.atomContent.setConnectionID(connectionID);
        Debug.enter((Logger)logger, (String)AtomEntry.class.getName(), (String)"setConnectionID", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public String getConnectionName() {
        return this.atomConnection;
    }

    public static AtomEntry parse(Element elem, String connectionID) {
        Debug.enter((Logger)logger, (String)AtomEntry.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomEntry entry = new AtomEntry();
        entry.atomConnection = connectionID;
        NodeList nodeList = elem.getElementsByTagName("*");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element child = (Element)nodeList.item(i);
            if (child.getParentNode() == elem) {
                if (child.getTagName() == "author") {
                    entry.author = AtomAuthor.parse(elem);
                } else if (child.getTagName() == "content") {
                    entry.atomContent = AtomContent.parse(child, connectionID);
                } else if (child.getTagName() == "link") {
                    entry.values.put(child.getAttribute("rel"), child.getAttribute("href"));
                } else {
                    entry.values.put(child.getTagName(), child.getTextContent());
                }
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)AtomEntry.class.getName(), (String)"parse");
        return entry;
    }
}

