/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ApplicationPropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ApplicationPropertySource.class.getPackage().getName());
    public static final String APPLICATION_NAME = "APPLICATION_NAME";
    public static final String APPLICATION_DESCRIPTION = "APPLICATION_DESCRIPTION";

    public ApplicationPropertySource(Resource resource) {
        super(resource);
        this.values.put(APPLICATION_NAME, ((IAApplication)resource).getName());
        this.values.put(APPLICATION_DESCRIPTION, ((IAApplication)resource).getApplicationDescription());
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)ApplicationPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null) {
            List properties = this.resource.getProperties();
            this.propertyDescriptors = new IPropertyDescriptor[2];
            this.propertyDescriptors[0] = new PropertyDescriptor((Object)APPLICATION_DESCRIPTION, Messages.getString(APPLICATION_DESCRIPTION));
            ((PropertyDescriptor)this.propertyDescriptors[0]).setCategory("Application");
            this.propertyDescriptors[1] = new PropertyDescriptor((Object)APPLICATION_NAME, Messages.getString(APPLICATION_NAME));
            ((PropertyDescriptor)this.propertyDescriptors[1]).setCategory("Application");
        }
        Debug.exit((Logger)logger, (String)ApplicationPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.propertyDescriptors;
    }
}

