/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AffGroupPropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffGroupPropertySource.class.getPackage().getName());
    private AffGroup affGroup;
    private IPropertyDescriptor[] propertyDescriptors;
    private Map values = new HashMap();
    public static String[] propertyIDs = new String[]{"APPLID", "TRANGROUP", "AFFTYPE", "GROUPTYPE", "AFFINITY", "AFFWORSENED", "LIFETIME", "LIFEWORSENED", "RECOVERY", "RESOURCE", "TYPE", "TRANCOUNT", "PROGCOUNT", "BUILD"};

    public AffGroupPropertySource(AffGroup anAffGroup) {
        Debug.enter((Logger)logger, (String)AffGroupPropertySource.class.getName(), (String)"AffGroupPropertySource", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.affGroup = anAffGroup;
        this.values = this.affGroup.getProperties();
        Debug.exit((Logger)logger, (String)AffGroupPropertySource.class.getName(), (String)"AffGroupPropertySource");
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)AffGroupPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null) {
            HashMap<String, String> properties = this.affGroup.getProperties();
            this.propertyDescriptors = new IPropertyDescriptor[propertyIDs.length];
            if (properties.size() > 0) {
                this.getValues(properties);
            } else {
                this.values = new HashMap();
            }
        }
        Debug.exit((Logger)logger, (String)AffGroupPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.propertyDescriptors;
    }

    private void getValues(Map properties) {
        Debug.enter((Logger)logger, (String)AffGroupPropertySource.class.getName(), (String)"getValues", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Map m = properties;
        int j = 0;
        while (j < propertyIDs.length) {
            String key = propertyIDs[j];
            String newKey = String.valueOf(key) + m.get("applid");
            this.values.put(newKey, m.get(key));
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
            descriptor.setCategory(Messages.getString("AffGroupPropertySource.0"));
            this.propertyDescriptors[j] = descriptor;
            ++j;
        }
        Debug.exit((Logger)logger, (String)AffGroupPropertySource.class.getName(), (String)"getValues");
    }

    public Object getPropertyValue(Object id) {
        return this.values.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

