/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroupPropertySource;
import com.ibm.cics.ia.model.AffinityLifetime;
import com.ibm.cics.ia.model.AffinityRelation;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AffGroup
implements IAdaptable,
IAffinityBuilderInputGroup {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffGroup.class.getPackage().getName());
    public static final String XML_AFFINITY_GROUP = "AffinityGroup";
    private String tranGroup;
    private Region region;
    private Resource resource;
    private HashMap<String, String> properties;
    private List<AffCommand> affCommands;
    private Set<Transaction> transactions;
    private AffinityRelation relation;
    private AffinityLifetime lifetime;
    private static final String xml10Exclude = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
    private AffGroupPropertySource propertySource;
    private transient Map adapters;

    @Override
    public void persist(Document doc, Element parent) {
        Debug.enter((Logger)logger, (String)AffGroup.class.getName(), (String)"persist", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "doc: " + (doc == null ? doc : doc.getLocalName()), "parent: " + (parent == null ? parent : parent.getLocalName())});
        Element element = doc.createElement(XML_AFFINITY_GROUP);
        if (parent != null) {
            parent.appendChild(element);
        } else {
            doc.appendChild(element);
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            value = value.replaceAll(xml10Exclude, "");
            element.setAttribute(key, value);
        }
        for (AffCommand affCommand : this.affCommands) {
            affCommand.persist(doc, element);
        }
        Debug.exit((Logger)logger, (String)AffGroup.class.getName(), (String)"persist", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public static AffGroup parseDOM(Element item) {
        Debug.enter((Logger)logger, (String)AffGroup.class.getName(), (String)"parseDOM", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "item: " + (item == null ? item : item.getLocalName())});
        NamedNodeMap attributesMap = item.getAttributes();
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 0;
        while (i < attributesMap.getLength()) {
            Node node = attributesMap.item(i);
            properties.put(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        if (properties.containsKey("TRANGROUP")) {
            AffGroup affGroup = new AffGroup((String)properties.get("TRANGROUP"), properties);
            ArrayList<AffCommand> affCommands = new ArrayList<AffCommand>();
            NodeList list = item.getChildNodes();
            int i2 = 0;
            while (i2 < list.getLength()) {
                AffCommand affCommand;
                Element item2;
                if (list.item(i2) instanceof Element && (item2 = (Element)list.item(i2)).getNodeName().equals("AffinityCommand") && (affCommand = AffCommand.parseDOM(item2, affGroup)) != null) {
                    affCommands.add(affCommand);
                }
                ++i2;
            }
            affGroup.affCommands = affCommands;
            Debug.exit((Logger)logger, (String)AffGroup.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "affGroup: " + affGroup.toString()});
            return affGroup;
        }
        Debug.exit((Logger)logger, (String)AffGroup.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "return null"});
        return null;
    }

    public AffGroup(String aTranGroup) {
        Debug.enter((Logger)logger, (String)AffGroup.class.getName(), (String)"AffGroup", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.properties = new HashMap();
        this.affCommands = null;
        this.tranGroup = aTranGroup;
        Debug.exit((Logger)logger, (String)AffGroup.class.getName(), (String)"AffGroup");
    }

    public AffGroup(String aTranGroup, HashMap<String, String> properties) {
        Debug.enter((Logger)logger, (String)AffGroup.class.getName(), (String)"AffGroup", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aTranGroup: " + aTranGroup, "properties: " + (properties == null ? aTranGroup : Integer.valueOf(properties.size()))});
        this.properties = properties;
        this.affCommands = null;
        this.tranGroup = aTranGroup;
        this.region = IAUtilities.hasContent(properties.get("APPLID")) ? ResourceFactory.getSingleton().getRegion(properties.get("APPLID")) : null;
        if (IAUtilities.hasContent(properties.get("AFFINITY"))) {
            this.relation = AffinityRelation.valueOf(properties.get("AFFINITY").toUpperCase());
        }
        if (this.relation == null) {
            this.relation = AffinityRelation.GLOBAL;
        }
        if (IAUtilities.hasContent(properties.get("LIFETIME"))) {
            this.lifetime = AffinityLifetime.valueOf(properties.get("LIFETIME").toUpperCase());
        }
        if (this.lifetime == null) {
            this.lifetime = AffinityLifetime.PERMANENT;
        }
        if (IAUtilities.hasContent(properties.get("RESOURCE"))) {
            String resType = "";
            if (IAUtilities.hasContent(properties.get("TYPE"))) {
                resType = properties.get("TYPE");
            }
            this.resource = ResourceFactory.getSingleton().getResource(resType, properties.get("RESOURCE"));
        } else {
            this.resource = null;
        }
        Debug.exit((Logger)logger, (String)AffGroup.class.getName(), (String)"AffGroup");
    }

    public void registerAdapter(Object adapter) {
        if (this.adapters == null) {
            this.adapters = new IdentityHashMap();
        }
        this.adapters.put(adapter.getClass(), adapter);
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new AffGroupPropertySource(this);
            }
            return this.propertySource;
        }
        return null;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getRegionName() {
        return this.properties.get("APPLID");
    }

    @Override
    public String getTranGroup() {
        return this.tranGroup;
    }

    @Override
    public void setTranGroup(String tranGroup) {
        this.tranGroup = tranGroup;
    }

    public String getAffType() {
        return this.properties.get("AFFTYPE");
    }

    public String getGroupType() {
        return this.properties.get("GROUPTYPE");
    }

    @Override
    public AffinityRelation getAffinity() {
        return this.relation;
    }

    @Override
    public void setAffinity(AffinityRelation affinity) {
        this.relation = affinity;
    }

    public String getAffWorsened() {
        return this.properties.get("AFFWORSENED");
    }

    @Override
    public AffinityLifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(AffinityLifetime lifetime) {
        this.lifetime = lifetime;
    }

    public String getLifeWorsened() {
        return this.properties.get("LIFEWORSENED");
    }

    public String getRecovery() {
        return this.properties.get("RECOVERY");
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getResourceName() {
        return this.properties.get("RESOURCE");
    }

    public String getType() {
        return this.properties.get("TYPE");
    }

    public String getTranCount() {
        return this.properties.get("TRANCOUNT");
    }

    public String getProgCount() {
        return this.properties.get("PROGCOUNT");
    }

    public String getBuild() {
        return this.properties.get("BUILD");
    }

    public List<AffCommand> getAffCommands() {
        if (this.affCommands == null) {
            Debug.event((Logger)logger, (Level)Level.FINEST, (String)AffGroup.class.getName(), (String)"getAffCommands()", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "affCommands==null"});
        }
        return this.affCommands;
    }

    public void setAffCommands(List<AffCommand> affCommands) {
        this.affCommands = affCommands;
    }

    @Override
    public Set<Transaction> getTransactions() {
        if (this.transactions == null) {
            this.transactions = new HashSet<Transaction>();
            if (this.affCommands != null) {
                for (AffCommand affCommand : this.affCommands) {
                    Transaction transaction = affCommand.getTransaction();
                    if (this.transactions.contains(transaction)) continue;
                    this.transactions.add(transaction);
                }
            }
        }
        return this.transactions;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.affCommands == null ? 0 : this.affCommands.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.tranGroup == null ? 0 : this.tranGroup.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AffGroup other = (AffGroup)obj;
        if (this.affCommands == null ? other.affCommands != null : !this.affCommands.equals(other.affCommands)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.tranGroup == null ? other.tranGroup != null : !this.tranGroup.equals(other.tranGroup));
    }

    @Override
    public void setTransactions(Set<Transaction> transactions) {
        Debug.enter((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"setTransactions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.transactions = transactions;
        Debug.exit((Logger)logger, (String)BuiltAffGroup.class.getName(), (String)"setTransactions", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public String toString() {
        return "AffGroup [tranGroup=" + this.tranGroup + ", region=" + this.region + ", properties=" + this.properties + ", relation=" + (Object)((Object)this.relation) + ", lifetime=" + (Object)((Object)this.lifetime) + "]";
    }
}

