/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffCommandPropertySource;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AffCommand
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffCommand.class.getPackage().getName());
    public static final String XML_AFFINITY_COMMAND = "AffinityCommand";
    private AffGroup affGroup;
    private Region region;
    private Program program;
    private Transaction transaction;
    private HashMap<String, String> properties;
    private AffCommandPropertySource propertySource;
    private transient Map adapters;

    public void persist(Document doc, Element parent) {
        Element element = doc.createElement(XML_AFFINITY_COMMAND);
        if (parent != null) {
            parent.appendChild(element);
        } else {
            doc.appendChild(element);
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            element.setAttribute(key, value);
        }
    }

    public static AffCommand parseDOM(Element item, AffGroup affGroup) {
        Debug.enter((Logger)logger, (String)AffCommand.class.getName(), (String)"parseDOM", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "item: " + (item == null ? item : item.getLocalName()), "anAffGroup commands: " + (affGroup == null ? affGroup : affGroup.getAffType())});
        NamedNodeMap attributesMap = item.getAttributes();
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 0;
        while (i < attributesMap.getLength()) {
            Node node = attributesMap.item(i);
            properties.put(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        AffCommand affCommand = new AffCommand(affGroup, properties);
        Debug.exit((Logger)logger, (String)AffCommand.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "affCommand: " + affCommand.getCommand()});
        return affCommand;
    }

    public AffCommand(AffGroup anAffGroup, HashMap<String, String> values) {
        Debug.enter((Logger)logger, (String)AffCommand.class.getName(), (String)"AffCommand", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "values size: " + (values == null ? values : Integer.valueOf(values.size())), "anAffGroup commands: " + (anAffGroup == null ? anAffGroup : anAffGroup.getAffType())});
        this.affGroup = anAffGroup;
        this.properties = values;
        this.region = this.affGroup.getRegion();
        this.transaction = IAUtilities.hasContent(this.properties.get("TRANSID")) ? ResourceFactory.getSingleton().getTransaction(this.properties.get("TRANSID")) : null;
        this.program = IAUtilities.hasContent(this.properties.get("PROGRAM")) ? ResourceFactory.getSingleton().getProgram(this.properties.get("PROGRAM")) : null;
        Debug.exit((Logger)logger, (String)AffCommand.class.getName(), (String)"AffCommand");
    }

    public void registerAdapter(Object adapter) {
        if (this.adapters == null) {
            this.adapters = new IdentityHashMap();
        }
        this.adapters.put(adapter.getClass(), adapter);
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new AffCommandPropertySource(this);
            }
            return this.propertySource;
        }
        return null;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getRegionName() {
        return this.properties.get("APPLID");
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public String getTransactionName() {
        return this.properties.get("TRANSID");
    }

    public Program getProgram() {
        return this.program;
    }

    public String getProgramName() {
        return this.properties.get("PROGRAM");
    }

    public String getOffset() {
        return this.properties.get("OFFSET");
    }

    public String getCommand() {
        return this.properties.get("COMMAND");
    }

    public String getResType() {
        return this.properties.get("RESTYPE");
    }

    public AffGroup getAffGroup() {
        return this.affGroup;
    }

    public String getAffGroupName() {
        return this.properties.get("AFFGROUP");
    }

    public String getTerminal() {
        return this.properties.get("TERMINAL");
    }

    public String getBTS() {
        return this.properties.get("BTS");
    }

    public String getLink3270() {
        return this.properties.get("LINK3270");
    }

    public String getUsage() {
        return this.properties.get("USAGE");
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.program == null ? 0 : this.program.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.transaction == null ? 0 : this.transaction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AffCommand other = (AffCommand)obj;
        if (this.program == null ? other.program != null : !this.program.equals(other.program)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.transaction == null ? other.transaction != null : !this.transaction.equals(other.transaction));
    }
}

