/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TransactionUsesProgramsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionUsesProgramsCommand.class.getPackage().getName());
    private Transaction transaction;

    public TransactionUsesProgramsCommand(Transaction transaction) {
        this.transaction = transaction;
        this.setAsync(false);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)TransactionUsesProgramsCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String applID = resultSet.getString(1);
        String programID = resultSet.getString(2);
        Region region = ResourceFactory.getSingleton().getRegion(applID.trim());
        Program program = ResourceFactory.getSingleton().getProgram(programID.trim());
        Interaction interaction = new Interaction(region, this.transaction, "", program, region);
        Debug.exit((Logger)logger, (String)TransactionUsesProgramsCommand.class.getName(), (String)"processRow");
        return interaction;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)TransactionUsesProgramsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCICSDataTableName();
        Selection result = this.getGenericSelection(table);
        Selection db2Selection = this.getGenericSelection(IAUtilities.getDB2DataTableName());
        Selection imsSelection = this.getGenericSelection(IAUtilities.getIMSDataTableName());
        Selection mqSelection = this.getGenericSelection(IAUtilities.getMQDataTableName());
        result.setUnion(db2Selection, false);
        db2Selection.setUnion(imsSelection, false);
        imsSelection.setUnion(mqSelection, false);
        mqSelection.addOrderByCondition("1", table, Direction.ASC);
        mqSelection.addOrderByCondition("2", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)TransactionUsesProgramsCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }

    private Selection getGenericSelection(String table) {
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.transaction.getName()}, QueryElement.Predicate.AND, false);
        return result;
    }
}

