/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TransactionOwnerUserIdsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionOwnerUserIdsCommand.class.getPackage().getName());
    private Transaction transaction;

    public TransactionOwnerUserIdsCommand(Transaction transaction) {
        this.transaction = transaction;
        this.setAsync(false);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        return resultSet.getString(1).trim();
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String commandFlowIndexTableName = IAUtilities.getCommandFlowIndexTableName();
        String commandFlowTableName = IAUtilities.getCommandFlowTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(new String[]{commandFlowIndexTableName, commandFlowTableName}, new String[2]);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("OWNER_USERID", commandFlowIndexTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        ColumnReference traceIdRef = PresentationFactory.getInstance().createBasicColumn("TRACE_ID", commandFlowTableName, ColumnReference.DataType.String);
        result.appendCondition("TRACE_ID", commandFlowIndexTableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{traceIdRef}, QueryElement.Predicate.AND, false);
        result.appendCondition("TRANSID", commandFlowTableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.transaction.getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("FUNCTION", commandFlowTableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"START OF TRANSACTION"}, QueryElement.Predicate.AND, false);
        result.addOrderByCondition("OWNER_USERID", commandFlowIndexTableName, Direction.ASC);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject");
        return result;
    }
}

