/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TransactionInitialProgramCommand1
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionInitialProgramCommand1.class.getPackage().getName());
    private Transaction transaction;
    private Region region;
    private Platform platform;
    private TSApplication tsApplication;

    public TransactionInitialProgramCommand1(Transaction transaction, Region region) {
        this(transaction, region, null, null);
    }

    public TransactionInitialProgramCommand1(Transaction transaction, Region region, Platform platform, TSApplication tsApplication) {
        Debug.enter((Logger)logger, (String)TransactionInitialProgramCommand1.class.getName(), (String)"TransactionInitialProgramCommand1", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.transaction = transaction;
        this.region = region;
        this.platform = platform;
        this.tsApplication = tsApplication;
        this.setAsync(false);
        Debug.exit((Logger)logger, (String)TransactionInitialProgramCommand1.class.getName(), (String)"TransactionInitialProgramCommand1");
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)TransactionInitialProgramCommand1.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int pos = 1;
        Region region = ResourceFactory.getSingleton().getRegion(resultSet.getString(pos++).trim());
        TSApplication application = null;
        Platform platform = null;
        if (Version.getInstance().getDBVersion() >= 5100) {
            if (Version.getInstance().getDBVersion() >= 5200) {
                String platformName = resultSet.getString(pos++).trim();
                platform = ResourceFactory.getSingleton().getPlatform(platformName);
            }
            String applName = resultSet.getString(pos++).trim();
            int applVer1 = resultSet.getInt(pos++);
            int applVer2 = resultSet.getInt(pos++);
            int applVer3 = resultSet.getInt(pos++);
            application = ResourceFactory.getSingleton().getTSApplication(platform, applName, applVer1, applVer2, applVer3);
        }
        String programID = resultSet.getString(pos++);
        Program program = ResourceFactory.getSingleton().getProgram(programID.trim());
        Resource[] row = new Resource[]{region, platform, application, program};
        Debug.exit((Logger)logger, (String)TransactionInitialProgramCommand1.class.getName(), (String)"processRow");
        return row;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)TransactionInitialProgramCommand1.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getTransactionPropertyTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (Version.getInstance().getDBVersion() >= 5100) {
            if (Version.getInstance().getDBVersion() >= 5200) {
                result.getSelect().addSelectionColumn("PLATFORM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            }
            result.getSelect().addSelectionColumn("APPL_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            result.getSelect().addSelectionColumn("APPL_VER1", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
            result.getSelect().addSelectionColumn("APPL_VER2", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
            result.getSelect().addSelectionColumn("APPL_VER3", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        }
        result.getSelect().addSelectionColumn("INITIAL_PROGRAM", table, ColumnReference.DataType.String, null);
        if (this.region != null) {
            result.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.platform != null) {
            result.appendCondition("PLATFORM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.platform.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.tsApplication != null) {
            result.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.tsApplication.getName()}, QueryElement.Predicate.AND, false);
            result.appendCondition("APPL_VER1", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMajorVersion()}, QueryElement.Predicate.AND, false);
            result.appendCondition("APPL_VER2", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMinorVersion()}, QueryElement.Predicate.AND, false);
            result.appendCondition("APPL_VER3", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMicroVersion()}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.transaction.getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("INITIAL_PROGRAM", table, ColumnReference.DataType.String, Comparator.LI, new Object[]{"DFHMIRS*"}, QueryElement.Predicate.AND, true);
        Debug.exit((Logger)logger, (String)TransactionInitialProgramCommand1.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

