/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.ThreadsafeReportCommand;
import com.ibm.cics.ia.model.threadsafe.Summary;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ThreadsafeSummaryReportCommand
extends ThreadsafeReportCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ThreadsafeSummaryReportCommand.class.getPackage().getName());

    public ThreadsafeSummaryReportCommand(String callType, String collectionId, String applId, String queryArg, String cicsTsLevel) {
        this.setCriteria(callType, collectionId, applId, queryArg, cicsTsLevel);
    }

    public ThreadsafeSummaryReportCommand() {
    }

    @Override
    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Summary summary = new Summary();
        summary.setApist(resultSet.getString(6).trim());
        summary.setCicsReleaseInternal(resultSet.getString(9).trim());
        summary.setCicsReleaseExternal(resultSet.getString(10).trim());
        summary.setCollectionId(resultSet.getString(1).trim());
        summary.setConcurrency(resultSet.getString(7).trim());
        summary.setExecutionKey(resultSet.getString(8).trim());
        summary.setLibDataset(resultSet.getString(5).trim());
        summary.setProgram(resultSet.getString(3).trim());
        summary.setApplid(resultSet.getString(2).trim());
        summary.setStorageProtect(resultSet.getString(11).trim());
        Summary.CicsCalls cicsCalls = new Summary.CicsCalls();
        cicsCalls.setTotalCicsCalls(resultSet.getInt(12));
        cicsCalls.setThreadsafe(resultSet.getInt(17));
        cicsCalls.setNonThreadsafe(resultSet.getInt(18));
        summary.setCicsCalls(cicsCalls);
        Summary.Db2MqCalls db2MqCalls = new Summary.Db2MqCalls();
        db2MqCalls.setTotalDb2Calls(resultSet.getInt(13));
        db2MqCalls.setTotalMqCalls(resultSet.getInt(14));
        db2MqCalls.setIndeterminateThreadsafe(resultSet.getInt(20));
        summary.setDb2MqCalls(db2MqCalls);
        Summary.ImsCalls imsCalls = new Summary.ImsCalls();
        imsCalls.setTotalImsCalls(resultSet.getInt(15));
        imsCalls.setDynamicCalls(resultSet.getInt(16));
        imsCalls.setThreadsafeInhibitorCalls(resultSet.getInt(19));
        summary.setImsCalls(imsCalls);
        if (Version.getInstance().getDBVersion() >= 5200) {
            Summary.CpsmCalls cpsmCalls = new Summary.CpsmCalls();
            cpsmCalls.setTotalCpsmCalls(resultSet.getInt(21));
            cpsmCalls.setThreadsafe(resultSet.getInt(22));
            cpsmCalls.setNonThreadsafe(resultSet.getInt(23));
            summary.setCpsmCalls(cpsmCalls);
            summary.setReentrant(resultSet.getString(24));
        } else {
            summary.setReentrant("?");
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow");
        return summary;
    }
}

